/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api;

import io.perfana.eventscheduler.EventSchedulerUtils;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CustomEvent {
    private static final Pattern nonAlphaNumsPattern = Pattern.compile("[^A-Za-z0-9\\- %+=:]");
    private final Duration duration;
    private final String name;
    private final String description;
    private final String settings;

    public CustomEvent(Duration duration, String name, String description, String settings) {
        this.duration = duration;
        this.name = name;
        this.description = EventSchedulerUtils.hasValue(description) ? description : name + "-" + duration.toString();
        this.settings = settings;
    }

    public CustomEvent(Duration duration, String name, String description) {
        this(duration, name, description, null);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public String getNameDescription() {
        return EventSchedulerUtils.hasValue(this.description) ? "(" + this.description + ")" : "";
    }

    public String getSettings() {
        return this.settings;
    }

    public static CustomEvent createFromLine(String line) {
        Duration duration;
        if (line == null || line.trim().isEmpty()) {
            throw new ScheduleEventWrongFormat("empty line: [" + line + "]");
        }
        if (!line.contains("|")) {
            throw new ScheduleEventWrongFormat("line should contain at least a duration and event name, separated by '|': [" + line + "]");
        }
        List elements = Arrays.stream(line.split("\\|")).map(String::trim).collect(Collectors.toList());
        if (elements.size() != 2 && elements.size() != 3) {
            throw new ScheduleEventWrongFormat("Wrong number of elements in line, expected 'duration|name(description)|setting' where (description) and settings are optional: [" + line + "]");
        }
        String textDuration = (String)elements.get(0);
        String nameWithDescription = ((String)elements.get(1)).trim();
        String[] nameAndDescriptionPair = CustomEvent.extractNameAndDescription(nameWithDescription);
        String name = nameAndDescriptionPair[0];
        String description = nameAndDescriptionPair[1];
        try {
            duration = Duration.parse(textDuration);
        }
        catch (Exception e) {
            throw new ScheduleEventWrongFormat("Failed to parse duration: [" + textDuration + "] from line: [" + line + "]", e);
        }
        if (elements.size() == 2) {
            return new CustomEvent(duration, name, description);
        }
        String settings = (String)elements.get(2);
        return new CustomEvent(duration, name, description, settings);
    }

    static String[] extractNameAndDescription(String nameWithDescription) {
        if (!EventSchedulerUtils.hasValue(nameWithDescription)) {
            return new String[]{"", ""};
        }
        if (!nameWithDescription.contains("(")) {
            return new String[]{nameWithDescription, ""};
        }
        int indexOpen = nameWithDescription.indexOf("(");
        int indexClose = nameWithDescription.lastIndexOf(")");
        if (indexClose == -1) {
            throw new EventSchedulerRuntimeException("closing parentheses ')' is missing in '" + nameWithDescription + "'");
        }
        String name = nameWithDescription.substring(0, indexOpen).trim();
        String description = nameWithDescription.substring(indexOpen + 1, indexClose).trim();
        String sanitizedName = nonAlphaNumsPattern.matcher(name).replaceAll("_");
        String sanitizedDescription = nonAlphaNumsPattern.matcher(description).replaceAll("_");
        return new String[]{sanitizedName, sanitizedDescription};
    }

    public String toString() {
        String formattedDesc = this.getNameDescription();
        return this.settings == null ? String.format("ScheduleEvent %s%s [fire-at=%s]", this.name, formattedDesc, this.duration) : String.format("ScheduleEvent %s%s [fire-at=%s settings=%s]", this.name, formattedDesc, this.duration, this.limitString(this.settings, 50));
    }

    private String limitString(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "...";
    }

    public String getDescription() {
        return this.description;
    }

    public static class ScheduleEventWrongFormat
    extends RuntimeException {
        public ScheduleEventWrongFormat(String message) {
            super(message);
        }

        public ScheduleEventWrongFormat(String message, Exception e) {
            super(message, e);
        }
    }
}

