/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api;

import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.Event;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public abstract class EventAdapter<T extends EventContext>
implements Event {
    protected final T eventContext;
    protected final TestContext testContext;
    protected final EventLogger logger;
    protected final EventMessageBus eventMessageBus;

    public EventAdapter(T context, TestContext testContext, EventMessageBus messageBus, EventLogger logger) {
        this.eventContext = context;
        this.testContext = testContext;
        this.logger = logger;
        this.eventMessageBus = messageBus;
    }

    @Override
    public void beforeTest() {
        this.logger.debug(String.format("[%s] [%s] beforeTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void startTest() {
        this.logger.debug(String.format("[%s] [%s] startTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void afterTest() {
        this.logger.debug(String.format("[%s] [%s] afterTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void keepAlive() {
        this.logger.debug(String.format("[%s] [%s] keepAlive (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void abortTest() {
        this.logger.debug(String.format("[%s] [%s] abortTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public EventCheck check() {
        return EventCheck.DEFAULT;
    }

    @Override
    public void customEvent(CustomEvent customEvent) {
        this.logger.debug(String.format("[%s] [%s] [%s] customEvent (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName(), customEvent.getName()));
    }

    @Override
    public final String getName() {
        return ((EventContext)this.eventContext).getName();
    }

    public static Set<String> setOf(String ... items) {
        return Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(items)));
    }

    @Override
    public boolean isContinueOnKeepAliveParticipant() {
        return ((EventContext)this.eventContext).isContinueOnKeepAliveParticipant();
    }

    @Override
    public boolean isReadyForStartParticipant() {
        return ((EventContext)this.eventContext).isReadyForStartParticipant();
    }
}

