/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api;

import io.perfana.eventscheduler.EventSchedulerUtils;
import io.perfana.eventscheduler.api.EventSchedulerSettings;
import java.time.Duration;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class EventSchedulerSettingsBuilder {
    private static final int DEFAULT_KEEP_ALIVE_TIME_SECONDS = 30;
    private Duration keepAliveInterval = Duration.ofSeconds(30L);

    public EventSchedulerSettingsBuilder setKeepAliveTimeInSeconds(String keepAliveTimeInSeconds) {
        this.keepAliveInterval = Duration.ofSeconds(EventSchedulerUtils.parseInt("keepAliveTimeInSeconds", keepAliveTimeInSeconds, 30));
        return this;
    }

    public EventSchedulerSettingsBuilder setKeepAliveInterval(Duration keepAliveInterval) {
        if (keepAliveInterval != null) {
            this.keepAliveInterval = keepAliveInterval;
        }
        return this;
    }

    public EventSchedulerSettings build() {
        return new EventSchedulerSettings(this.keepAliveInterval);
    }
}

