/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api.config;

import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.config.EventConfig;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.EventSchedulerContext;
import io.perfana.eventscheduler.api.config.TestConfig;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class EventSchedulerConfig {
    private boolean debugEnabled;
    private boolean schedulerEnabled;
    private boolean failOnError;
    private boolean continueOnEventCheckFailure;
    private Integer keepAliveIntervalInSeconds;
    private String scheduleScript;
    private List<EventConfig> eventConfigs;
    private TestConfig testConfig;

    public EventSchedulerContext toContext(EventLogger logger) {
        if (this.testConfig == null) {
            throw new EventSchedulerRuntimeException("no testConfig found in eventSchedulerConfig");
        }
        List<EventContext> eventContexts = this.eventConfigs.stream().map(EventConfig::toContext).collect(Collectors.toList());
        String allScheduleScripts = EventSchedulerConfig.collectScheduleScripts(eventContexts, this.scheduleScript);
        return EventSchedulerContext.builder().debugEnabled(this.debugEnabled).schedulerEnabled(this.schedulerEnabled).failOnError(this.failOnError).continueOnEventCheckFailure(this.continueOnEventCheckFailure).keepAliveInterval(Duration.ofSeconds(this.keepAliveIntervalInSeconds.intValue())).scheduleScript(allScheduleScripts).eventContexts(eventContexts).testContext(this.testConfig.toContext()).build();
    }

    private static String collectScheduleScripts(List<EventContext> eventContexts, String topScheduleScript) {
        String allSubScripts = eventContexts.stream().map(EventContext::getScheduleScript).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (topScheduleScript == null) {
            return EventSchedulerConfig.removeEmptyLines(allSubScripts);
        }
        return EventSchedulerConfig.removeEmptyLines(String.join((CharSequence)"\n", topScheduleScript, allSubScripts));
    }

    private static String removeEmptyLines(String text) {
        return Arrays.stream(text.split("\\n")).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.joining("\n"));
    }

    private static boolean $default$debugEnabled() {
        return false;
    }

    private static boolean $default$schedulerEnabled() {
        return true;
    }

    private static boolean $default$failOnError() {
        return true;
    }

    private static boolean $default$continueOnEventCheckFailure() {
        return true;
    }

    private static Integer $default$keepAliveIntervalInSeconds() {
        return 30;
    }

    private static String $default$scheduleScript() {
        return null;
    }

    private static TestConfig $default$testConfig() {
        return null;
    }

    public static EventSchedulerConfigBuilder builder() {
        return new EventSchedulerConfigBuilder();
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isContinueOnEventCheckFailure() {
        return this.continueOnEventCheckFailure;
    }

    public Integer getKeepAliveIntervalInSeconds() {
        return this.keepAliveIntervalInSeconds;
    }

    public String getScheduleScript() {
        return this.scheduleScript;
    }

    public List<EventConfig> getEventConfigs() {
        return this.eventConfigs;
    }

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setSchedulerEnabled(boolean schedulerEnabled) {
        this.schedulerEnabled = schedulerEnabled;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setContinueOnEventCheckFailure(boolean continueOnEventCheckFailure) {
        this.continueOnEventCheckFailure = continueOnEventCheckFailure;
    }

    public void setKeepAliveIntervalInSeconds(Integer keepAliveIntervalInSeconds) {
        this.keepAliveIntervalInSeconds = keepAliveIntervalInSeconds;
    }

    public void setScheduleScript(String scheduleScript) {
        this.scheduleScript = scheduleScript;
    }

    public void setEventConfigs(List<EventConfig> eventConfigs) {
        this.eventConfigs = eventConfigs;
    }

    public void setTestConfig(TestConfig testConfig) {
        this.testConfig = testConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSchedulerConfig)) {
            return false;
        }
        EventSchedulerConfig other = (EventSchedulerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebugEnabled() != other.isDebugEnabled()) {
            return false;
        }
        if (this.isSchedulerEnabled() != other.isSchedulerEnabled()) {
            return false;
        }
        if (this.isFailOnError() != other.isFailOnError()) {
            return false;
        }
        if (this.isContinueOnEventCheckFailure() != other.isContinueOnEventCheckFailure()) {
            return false;
        }
        Integer this$keepAliveIntervalInSeconds = this.getKeepAliveIntervalInSeconds();
        Integer other$keepAliveIntervalInSeconds = other.getKeepAliveIntervalInSeconds();
        if (this$keepAliveIntervalInSeconds == null ? other$keepAliveIntervalInSeconds != null : !((Object)this$keepAliveIntervalInSeconds).equals(other$keepAliveIntervalInSeconds)) {
            return false;
        }
        String this$scheduleScript = this.getScheduleScript();
        String other$scheduleScript = other.getScheduleScript();
        if (this$scheduleScript == null ? other$scheduleScript != null : !this$scheduleScript.equals(other$scheduleScript)) {
            return false;
        }
        List<EventConfig> this$eventConfigs = this.getEventConfigs();
        List<EventConfig> other$eventConfigs = other.getEventConfigs();
        if (this$eventConfigs == null ? other$eventConfigs != null : !((Object)this$eventConfigs).equals(other$eventConfigs)) {
            return false;
        }
        TestConfig this$testConfig = this.getTestConfig();
        TestConfig other$testConfig = other.getTestConfig();
        return !(this$testConfig == null ? other$testConfig != null : !this$testConfig.equals(other$testConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventSchedulerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugEnabled() ? 79 : 97);
        result = result * 59 + (this.isSchedulerEnabled() ? 79 : 97);
        result = result * 59 + (this.isFailOnError() ? 79 : 97);
        result = result * 59 + (this.isContinueOnEventCheckFailure() ? 79 : 97);
        Integer $keepAliveIntervalInSeconds = this.getKeepAliveIntervalInSeconds();
        result = result * 59 + ($keepAliveIntervalInSeconds == null ? 43 : ((Object)$keepAliveIntervalInSeconds).hashCode());
        String $scheduleScript = this.getScheduleScript();
        result = result * 59 + ($scheduleScript == null ? 43 : $scheduleScript.hashCode());
        List<EventConfig> $eventConfigs = this.getEventConfigs();
        result = result * 59 + ($eventConfigs == null ? 43 : ((Object)$eventConfigs).hashCode());
        TestConfig $testConfig = this.getTestConfig();
        result = result * 59 + ($testConfig == null ? 43 : $testConfig.hashCode());
        return result;
    }

    public String toString() {
        return "EventSchedulerConfig(debugEnabled=" + this.isDebugEnabled() + ", schedulerEnabled=" + this.isSchedulerEnabled() + ", failOnError=" + this.isFailOnError() + ", continueOnEventCheckFailure=" + this.isContinueOnEventCheckFailure() + ", keepAliveIntervalInSeconds=" + this.getKeepAliveIntervalInSeconds() + ", scheduleScript=" + this.getScheduleScript() + ", eventConfigs=" + this.getEventConfigs() + ", testConfig=" + this.getTestConfig() + ")";
    }

    public EventSchedulerConfig(boolean debugEnabled, boolean schedulerEnabled, boolean failOnError, boolean continueOnEventCheckFailure, Integer keepAliveIntervalInSeconds, String scheduleScript, List<EventConfig> eventConfigs, TestConfig testConfig) {
        this.debugEnabled = debugEnabled;
        this.schedulerEnabled = schedulerEnabled;
        this.failOnError = failOnError;
        this.continueOnEventCheckFailure = continueOnEventCheckFailure;
        this.keepAliveIntervalInSeconds = keepAliveIntervalInSeconds;
        this.scheduleScript = scheduleScript;
        this.eventConfigs = eventConfigs;
        this.testConfig = testConfig;
    }

    public EventSchedulerConfig() {
        this.debugEnabled = EventSchedulerConfig.$default$debugEnabled();
        this.schedulerEnabled = EventSchedulerConfig.$default$schedulerEnabled();
        this.failOnError = EventSchedulerConfig.$default$failOnError();
        this.continueOnEventCheckFailure = EventSchedulerConfig.$default$continueOnEventCheckFailure();
        this.keepAliveIntervalInSeconds = EventSchedulerConfig.$default$keepAliveIntervalInSeconds();
        this.scheduleScript = EventSchedulerConfig.$default$scheduleScript();
        this.testConfig = EventSchedulerConfig.$default$testConfig();
    }

    public static class EventSchedulerConfigBuilder {
        private boolean debugEnabled$set;
        private boolean debugEnabled$value;
        private boolean schedulerEnabled$set;
        private boolean schedulerEnabled$value;
        private boolean failOnError$set;
        private boolean failOnError$value;
        private boolean continueOnEventCheckFailure$set;
        private boolean continueOnEventCheckFailure$value;
        private boolean keepAliveIntervalInSeconds$set;
        private Integer keepAliveIntervalInSeconds$value;
        private boolean scheduleScript$set;
        private String scheduleScript$value;
        private ArrayList<EventConfig> eventConfigs;
        private boolean testConfig$set;
        private TestConfig testConfig$value;

        EventSchedulerConfigBuilder() {
        }

        public EventSchedulerConfigBuilder debugEnabled(boolean debugEnabled) {
            this.debugEnabled$value = debugEnabled;
            this.debugEnabled$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder schedulerEnabled(boolean schedulerEnabled) {
            this.schedulerEnabled$value = schedulerEnabled;
            this.schedulerEnabled$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder failOnError(boolean failOnError) {
            this.failOnError$value = failOnError;
            this.failOnError$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder continueOnEventCheckFailure(boolean continueOnEventCheckFailure) {
            this.continueOnEventCheckFailure$value = continueOnEventCheckFailure;
            this.continueOnEventCheckFailure$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder keepAliveIntervalInSeconds(Integer keepAliveIntervalInSeconds) {
            this.keepAliveIntervalInSeconds$value = keepAliveIntervalInSeconds;
            this.keepAliveIntervalInSeconds$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder scheduleScript(String scheduleScript) {
            this.scheduleScript$value = scheduleScript;
            this.scheduleScript$set = true;
            return this;
        }

        public EventSchedulerConfigBuilder eventConfig(EventConfig eventConfig) {
            if (this.eventConfigs == null) {
                this.eventConfigs = new ArrayList();
            }
            this.eventConfigs.add(eventConfig);
            return this;
        }

        public EventSchedulerConfigBuilder eventConfigs(Collection<? extends EventConfig> eventConfigs) {
            if (eventConfigs == null) {
                throw new NullPointerException("eventConfigs cannot be null");
            }
            if (this.eventConfigs == null) {
                this.eventConfigs = new ArrayList();
            }
            this.eventConfigs.addAll(eventConfigs);
            return this;
        }

        public EventSchedulerConfigBuilder clearEventConfigs() {
            if (this.eventConfigs != null) {
                this.eventConfigs.clear();
            }
            return this;
        }

        public EventSchedulerConfigBuilder testConfig(TestConfig testConfig) {
            this.testConfig$value = testConfig;
            this.testConfig$set = true;
            return this;
        }

        public EventSchedulerConfig build() {
            List<EventConfig> eventConfigs;
            switch (this.eventConfigs == null ? 0 : this.eventConfigs.size()) {
                case 0: {
                    eventConfigs = Collections.emptyList();
                    break;
                }
                case 1: {
                    eventConfigs = Collections.singletonList(this.eventConfigs.get(0));
                    break;
                }
                default: {
                    eventConfigs = Collections.unmodifiableList(new ArrayList<EventConfig>(this.eventConfigs));
                }
            }
            boolean debugEnabled$value = this.debugEnabled$value;
            if (!this.debugEnabled$set) {
                debugEnabled$value = EventSchedulerConfig.$default$debugEnabled();
            }
            boolean schedulerEnabled$value = this.schedulerEnabled$value;
            if (!this.schedulerEnabled$set) {
                schedulerEnabled$value = EventSchedulerConfig.$default$schedulerEnabled();
            }
            boolean failOnError$value = this.failOnError$value;
            if (!this.failOnError$set) {
                failOnError$value = EventSchedulerConfig.$default$failOnError();
            }
            boolean continueOnEventCheckFailure$value = this.continueOnEventCheckFailure$value;
            if (!this.continueOnEventCheckFailure$set) {
                continueOnEventCheckFailure$value = EventSchedulerConfig.$default$continueOnEventCheckFailure();
            }
            Integer keepAliveIntervalInSeconds$value = this.keepAliveIntervalInSeconds$value;
            if (!this.keepAliveIntervalInSeconds$set) {
                keepAliveIntervalInSeconds$value = EventSchedulerConfig.$default$keepAliveIntervalInSeconds();
            }
            String scheduleScript$value = this.scheduleScript$value;
            if (!this.scheduleScript$set) {
                scheduleScript$value = EventSchedulerConfig.$default$scheduleScript();
            }
            TestConfig testConfig$value = this.testConfig$value;
            if (!this.testConfig$set) {
                testConfig$value = EventSchedulerConfig.$default$testConfig();
            }
            return new EventSchedulerConfig(debugEnabled$value, schedulerEnabled$value, failOnError$value, continueOnEventCheckFailure$value, keepAliveIntervalInSeconds$value, scheduleScript$value, eventConfigs, testConfig$value);
        }

        public String toString() {
            return "EventSchedulerConfig.EventSchedulerConfigBuilder(debugEnabled$value=" + this.debugEnabled$value + ", schedulerEnabled$value=" + this.schedulerEnabled$value + ", failOnError$value=" + this.failOnError$value + ", continueOnEventCheckFailure$value=" + this.continueOnEventCheckFailure$value + ", keepAliveIntervalInSeconds$value=" + this.keepAliveIntervalInSeconds$value + ", scheduleScript$value=" + this.scheduleScript$value + ", eventConfigs=" + this.eventConfigs + ", testConfig$value=" + this.testConfig$value + ")";
        }
    }
}

