/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api.config;

import io.perfana.eventscheduler.api.config.TestContext;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class TestConfig {
    private String systemUnderTest;
    private String workload;
    private String testEnvironment;
    private String productName;
    private String dashboardName;
    private String testRunId;
    private String buildResultsUrl;
    private String version;
    private String annotations;
    private List<String> tags;
    private Integer rampupTimeInSeconds;
    private Integer constantLoadTimeInSeconds;

    public TestContext toContext() {
        return TestContext.builder().systemUnderTest(this.systemUnderTest).workload(this.workload).testEnvironment(this.testEnvironment).productName(this.productName).dashboardName(this.dashboardName).testRunId(this.testRunId).buildResultsUrl(this.buildResultsUrl).version(this.version).annotations(this.annotations).tags(this.tags).rampupTime(Duration.ofSeconds(this.rampupTimeInSeconds.intValue())).constantLoadTime(Duration.ofSeconds(this.constantLoadTimeInSeconds.intValue())).build();
    }

    private static String $default$systemUnderTest() {
        return "UNKNOWN_SYSTEM_UNDER_TEST";
    }

    private static String $default$workload() {
        return "UNKNOWN_WORKLOAD";
    }

    private static String $default$testEnvironment() {
        return "UNKNOWN_TEST_ENVIRONMENT";
    }

    private static String $default$productName() {
        return "ANONYMOUS_PRODUCT";
    }

    private static String $default$dashboardName() {
        return "ANONYMOUS_DASHBOARD";
    }

    private static String $default$testRunId() {
        return "ANONYMOUS_TEST_ID";
    }

    private static String $default$buildResultsUrl() {
        return null;
    }

    private static String $default$version() {
        return "1.0.0-SNAPSHOT";
    }

    private static String $default$annotations() {
        return "";
    }

    private static List<String> $default$tags() {
        return Collections.emptyList();
    }

    private static Integer $default$rampupTimeInSeconds() {
        return 30;
    }

    private static Integer $default$constantLoadTimeInSeconds() {
        return 570;
    }

    public static TestConfigBuilder builder() {
        return new TestConfigBuilder();
    }

    public void setSystemUnderTest(String systemUnderTest) {
        this.systemUnderTest = systemUnderTest;
    }

    public void setWorkload(String workload) {
        this.workload = workload;
    }

    public void setTestEnvironment(String testEnvironment) {
        this.testEnvironment = testEnvironment;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public void setTestRunId(String testRunId) {
        this.testRunId = testRunId;
    }

    public void setBuildResultsUrl(String buildResultsUrl) {
        this.buildResultsUrl = buildResultsUrl;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setRampupTimeInSeconds(Integer rampupTimeInSeconds) {
        this.rampupTimeInSeconds = rampupTimeInSeconds;
    }

    public void setConstantLoadTimeInSeconds(Integer constantLoadTimeInSeconds) {
        this.constantLoadTimeInSeconds = constantLoadTimeInSeconds;
    }

    public TestConfig(String systemUnderTest, String workload, String testEnvironment, String productName, String dashboardName, String testRunId, String buildResultsUrl, String version, String annotations, List<String> tags, Integer rampupTimeInSeconds, Integer constantLoadTimeInSeconds) {
        this.systemUnderTest = systemUnderTest;
        this.workload = workload;
        this.testEnvironment = testEnvironment;
        this.productName = productName;
        this.dashboardName = dashboardName;
        this.testRunId = testRunId;
        this.buildResultsUrl = buildResultsUrl;
        this.version = version;
        this.annotations = annotations;
        this.tags = tags;
        this.rampupTimeInSeconds = rampupTimeInSeconds;
        this.constantLoadTimeInSeconds = constantLoadTimeInSeconds;
    }

    public TestConfig() {
        this.systemUnderTest = TestConfig.$default$systemUnderTest();
        this.workload = TestConfig.$default$workload();
        this.testEnvironment = TestConfig.$default$testEnvironment();
        this.productName = TestConfig.$default$productName();
        this.dashboardName = TestConfig.$default$dashboardName();
        this.testRunId = TestConfig.$default$testRunId();
        this.buildResultsUrl = TestConfig.$default$buildResultsUrl();
        this.version = TestConfig.$default$version();
        this.annotations = TestConfig.$default$annotations();
        this.tags = TestConfig.$default$tags();
        this.rampupTimeInSeconds = TestConfig.$default$rampupTimeInSeconds();
        this.constantLoadTimeInSeconds = TestConfig.$default$constantLoadTimeInSeconds();
    }

    public static class TestConfigBuilder {
        private boolean systemUnderTest$set;
        private String systemUnderTest$value;
        private boolean workload$set;
        private String workload$value;
        private boolean testEnvironment$set;
        private String testEnvironment$value;
        private boolean productName$set;
        private String productName$value;
        private boolean dashboardName$set;
        private String dashboardName$value;
        private boolean testRunId$set;
        private String testRunId$value;
        private boolean buildResultsUrl$set;
        private String buildResultsUrl$value;
        private boolean version$set;
        private String version$value;
        private boolean annotations$set;
        private String annotations$value;
        private boolean tags$set;
        private List<String> tags$value;
        private boolean rampupTimeInSeconds$set;
        private Integer rampupTimeInSeconds$value;
        private boolean constantLoadTimeInSeconds$set;
        private Integer constantLoadTimeInSeconds$value;

        TestConfigBuilder() {
        }

        public TestConfigBuilder systemUnderTest(String systemUnderTest) {
            this.systemUnderTest$value = systemUnderTest;
            this.systemUnderTest$set = true;
            return this;
        }

        public TestConfigBuilder workload(String workload) {
            this.workload$value = workload;
            this.workload$set = true;
            return this;
        }

        public TestConfigBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment$value = testEnvironment;
            this.testEnvironment$set = true;
            return this;
        }

        public TestConfigBuilder productName(String productName) {
            this.productName$value = productName;
            this.productName$set = true;
            return this;
        }

        public TestConfigBuilder dashboardName(String dashboardName) {
            this.dashboardName$value = dashboardName;
            this.dashboardName$set = true;
            return this;
        }

        public TestConfigBuilder testRunId(String testRunId) {
            this.testRunId$value = testRunId;
            this.testRunId$set = true;
            return this;
        }

        public TestConfigBuilder buildResultsUrl(String buildResultsUrl) {
            this.buildResultsUrl$value = buildResultsUrl;
            this.buildResultsUrl$set = true;
            return this;
        }

        public TestConfigBuilder version(String version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public TestConfigBuilder annotations(String annotations) {
            this.annotations$value = annotations;
            this.annotations$set = true;
            return this;
        }

        public TestConfigBuilder tags(List<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        public TestConfigBuilder rampupTimeInSeconds(Integer rampupTimeInSeconds) {
            this.rampupTimeInSeconds$value = rampupTimeInSeconds;
            this.rampupTimeInSeconds$set = true;
            return this;
        }

        public TestConfigBuilder constantLoadTimeInSeconds(Integer constantLoadTimeInSeconds) {
            this.constantLoadTimeInSeconds$value = constantLoadTimeInSeconds;
            this.constantLoadTimeInSeconds$set = true;
            return this;
        }

        public TestConfig build() {
            String systemUnderTest$value = this.systemUnderTest$value;
            if (!this.systemUnderTest$set) {
                systemUnderTest$value = TestConfig.$default$systemUnderTest();
            }
            String workload$value = this.workload$value;
            if (!this.workload$set) {
                workload$value = TestConfig.$default$workload();
            }
            String testEnvironment$value = this.testEnvironment$value;
            if (!this.testEnvironment$set) {
                testEnvironment$value = TestConfig.$default$testEnvironment();
            }
            String productName$value = this.productName$value;
            if (!this.productName$set) {
                productName$value = TestConfig.$default$productName();
            }
            String dashboardName$value = this.dashboardName$value;
            if (!this.dashboardName$set) {
                dashboardName$value = TestConfig.$default$dashboardName();
            }
            String testRunId$value = this.testRunId$value;
            if (!this.testRunId$set) {
                testRunId$value = TestConfig.$default$testRunId();
            }
            String buildResultsUrl$value = this.buildResultsUrl$value;
            if (!this.buildResultsUrl$set) {
                buildResultsUrl$value = TestConfig.$default$buildResultsUrl();
            }
            String version$value = this.version$value;
            if (!this.version$set) {
                version$value = TestConfig.$default$version();
            }
            String annotations$value = this.annotations$value;
            if (!this.annotations$set) {
                annotations$value = TestConfig.$default$annotations();
            }
            List<String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = TestConfig.$default$tags();
            }
            Integer rampupTimeInSeconds$value = this.rampupTimeInSeconds$value;
            if (!this.rampupTimeInSeconds$set) {
                rampupTimeInSeconds$value = TestConfig.$default$rampupTimeInSeconds();
            }
            Integer constantLoadTimeInSeconds$value = this.constantLoadTimeInSeconds$value;
            if (!this.constantLoadTimeInSeconds$set) {
                constantLoadTimeInSeconds$value = TestConfig.$default$constantLoadTimeInSeconds();
            }
            return new TestConfig(systemUnderTest$value, workload$value, testEnvironment$value, productName$value, dashboardName$value, testRunId$value, buildResultsUrl$value, version$value, annotations$value, tags$value, rampupTimeInSeconds$value, constantLoadTimeInSeconds$value);
        }

        public String toString() {
            return "TestConfig.TestConfigBuilder(systemUnderTest$value=" + this.systemUnderTest$value + ", workload$value=" + this.workload$value + ", testEnvironment$value=" + this.testEnvironment$value + ", productName$value=" + this.productName$value + ", dashboardName$value=" + this.dashboardName$value + ", testRunId$value=" + this.testRunId$value + ", buildResultsUrl$value=" + this.buildResultsUrl$value + ", version$value=" + this.version$value + ", annotations$value=" + this.annotations$value + ", tags$value=" + this.tags$value + ", rampupTimeInSeconds$value=" + this.rampupTimeInSeconds$value + ", constantLoadTimeInSeconds$value=" + this.constantLoadTimeInSeconds$value + ")";
        }
    }
}

