/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class TestContext {
    private final String systemUnderTest;
    private final String workload;
    private final String testEnvironment;
    private final String productName;
    private final String dashboardName;
    private final String testRunId;
    private final String buildResultsUrl;
    private final String version;
    private final String annotations;
    private final List<String> tags;
    private final Duration rampupTime;
    private final Duration constantLoadTime;

    TestContext(String systemUnderTest, String workload, String testEnvironment, String productName, String dashboardName, String testRunId, String buildResultsUrl, String version, String annotations, List<String> tags, Duration rampupTime, Duration constantLoadTime) {
        this.systemUnderTest = systemUnderTest;
        this.workload = workload;
        this.testEnvironment = testEnvironment;
        this.productName = productName;
        this.dashboardName = dashboardName;
        this.testRunId = testRunId;
        this.buildResultsUrl = buildResultsUrl;
        this.version = version;
        this.annotations = annotations;
        this.tags = tags;
        this.rampupTime = rampupTime;
        this.constantLoadTime = constantLoadTime;
    }

    protected static TestContextBuilder builder() {
        return new TestContextBuilder();
    }

    public String getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getBuildResultsUrl() {
        return this.buildResultsUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Duration getRampupTime() {
        return this.rampupTime;
    }

    public Duration getConstantLoadTime() {
        return this.constantLoadTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestContext)) {
            return false;
        }
        TestContext other = (TestContext)o;
        String this$systemUnderTest = this.getSystemUnderTest();
        String other$systemUnderTest = other.getSystemUnderTest();
        if (this$systemUnderTest == null ? other$systemUnderTest != null : !this$systemUnderTest.equals(other$systemUnderTest)) {
            return false;
        }
        String this$workload = this.getWorkload();
        String other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !this$workload.equals(other$workload)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$dashboardName = this.getDashboardName();
        String other$dashboardName = other.getDashboardName();
        if (this$dashboardName == null ? other$dashboardName != null : !this$dashboardName.equals(other$dashboardName)) {
            return false;
        }
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        String this$buildResultsUrl = this.getBuildResultsUrl();
        String other$buildResultsUrl = other.getBuildResultsUrl();
        if (this$buildResultsUrl == null ? other$buildResultsUrl != null : !this$buildResultsUrl.equals(other$buildResultsUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$annotations = this.getAnnotations();
        String other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Duration this$rampupTime = this.getRampupTime();
        Duration other$rampupTime = other.getRampupTime();
        if (this$rampupTime == null ? other$rampupTime != null : !((Object)this$rampupTime).equals(other$rampupTime)) {
            return false;
        }
        Duration this$constantLoadTime = this.getConstantLoadTime();
        Duration other$constantLoadTime = other.getConstantLoadTime();
        return !(this$constantLoadTime == null ? other$constantLoadTime != null : !((Object)this$constantLoadTime).equals(other$constantLoadTime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $systemUnderTest = this.getSystemUnderTest();
        result = result * 59 + ($systemUnderTest == null ? 43 : $systemUnderTest.hashCode());
        String $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : $workload.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $dashboardName = this.getDashboardName();
        result = result * 59 + ($dashboardName == null ? 43 : $dashboardName.hashCode());
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        String $buildResultsUrl = this.getBuildResultsUrl();
        result = result * 59 + ($buildResultsUrl == null ? 43 : $buildResultsUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : $annotations.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Duration $rampupTime = this.getRampupTime();
        result = result * 59 + ($rampupTime == null ? 43 : ((Object)$rampupTime).hashCode());
        Duration $constantLoadTime = this.getConstantLoadTime();
        result = result * 59 + ($constantLoadTime == null ? 43 : ((Object)$constantLoadTime).hashCode());
        return result;
    }

    public String toString() {
        return "TestContext(systemUnderTest=" + this.getSystemUnderTest() + ", workload=" + this.getWorkload() + ", testEnvironment=" + this.getTestEnvironment() + ", productName=" + this.getProductName() + ", dashboardName=" + this.getDashboardName() + ", testRunId=" + this.getTestRunId() + ", buildResultsUrl=" + this.getBuildResultsUrl() + ", version=" + this.getVersion() + ", annotations=" + this.getAnnotations() + ", tags=" + this.getTags() + ", rampupTime=" + this.getRampupTime() + ", constantLoadTime=" + this.getConstantLoadTime() + ")";
    }

    public TestContext withTestRunId(String testRunId) {
        return this.testRunId == testRunId ? this : new TestContext(this.systemUnderTest, this.workload, this.testEnvironment, this.productName, this.dashboardName, testRunId, this.buildResultsUrl, this.version, this.annotations, this.tags, this.rampupTime, this.constantLoadTime);
    }

    protected static class TestContextBuilder {
        private String systemUnderTest;
        private String workload;
        private String testEnvironment;
        private String productName;
        private String dashboardName;
        private String testRunId;
        private String buildResultsUrl;
        private String version;
        private String annotations;
        private ArrayList<String> tags;
        private Duration rampupTime;
        private Duration constantLoadTime;

        TestContextBuilder() {
        }

        public TestContextBuilder systemUnderTest(String systemUnderTest) {
            this.systemUnderTest = systemUnderTest;
            return this;
        }

        public TestContextBuilder workload(String workload) {
            this.workload = workload;
            return this;
        }

        public TestContextBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public TestContextBuilder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public TestContextBuilder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public TestContextBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public TestContextBuilder buildResultsUrl(String buildResultsUrl) {
            this.buildResultsUrl = buildResultsUrl;
            return this;
        }

        public TestContextBuilder version(String version) {
            this.version = version;
            return this;
        }

        public TestContextBuilder annotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        public TestContextBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public TestContextBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public TestContextBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public TestContextBuilder rampupTime(Duration rampupTime) {
            this.rampupTime = rampupTime;
            return this;
        }

        public TestContextBuilder constantLoadTime(Duration constantLoadTime) {
            this.constantLoadTime = constantLoadTime;
            return this;
        }

        public TestContext build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new TestContext(this.systemUnderTest, this.workload, this.testEnvironment, this.productName, this.dashboardName, this.testRunId, this.buildResultsUrl, this.version, this.annotations, tags, this.rampupTime, this.constantLoadTime);
        }

        public String toString() {
            return "TestContext.TestContextBuilder(systemUnderTest=" + this.systemUnderTest + ", workload=" + this.workload + ", testEnvironment=" + this.testEnvironment + ", productName=" + this.productName + ", dashboardName=" + this.dashboardName + ", testRunId=" + this.testRunId + ", buildResultsUrl=" + this.buildResultsUrl + ", version=" + this.version + ", annotations=" + this.annotations + ", tags=" + this.tags + ", rampupTime=" + this.rampupTime + ", constantLoadTime=" + this.constantLoadTime + ")";
        }
    }
}

