/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.event;

import io.perfana.eventscheduler.api.TestContextInitializerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class TestContextInitializerFactoryProvider {
    private final Map<String, TestContextInitializerFactory<?>> testContextInitializerFactories;

    private TestContextInitializerFactoryProvider(List<TestContextInitializerFactory<?>> testContextInitializerFactories) {
        Map<String, TestContextInitializerFactory> map = testContextInitializerFactories.stream().collect(Collectors.toMap(f -> f.getClass().getName(), f -> f));
        this.testContextInitializerFactories = Collections.unmodifiableMap(map);
    }

    public static TestContextInitializerFactoryProvider createInstanceFromClasspath() {
        return TestContextInitializerFactoryProvider.createInstanceFromClasspath(null);
    }

    public static TestContextInitializerFactoryProvider createInstanceFromClasspath(ClassLoader classLoader) {
        ServiceLoader<TestContextInitializerFactory> testContextInitializerServiceLoader = classLoader == null ? ServiceLoader.load(TestContextInitializerFactory.class) : ServiceLoader.load(TestContextInitializerFactory.class, classLoader);
        ArrayList testContextInitializerFactories = new ArrayList();
        for (TestContextInitializerFactory testContextInitializerFactory : testContextInitializerServiceLoader) {
            testContextInitializerFactories.add(testContextInitializerFactory);
        }
        return new TestContextInitializerFactoryProvider(testContextInitializerFactories);
    }

    public Optional<TestContextInitializerFactory> factoryByClassName(String className) {
        return Optional.ofNullable(this.testContextInitializerFactories.get(className));
    }

    public List<TestContextInitializerFactory> getTestContextInitializerFactories() {
        return new ArrayList<TestContextInitializerFactory>(this.testContextInitializerFactories.values());
    }
}

