/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler;

import io.perfana.eventscheduler.EventBroadcaster;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.Event;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.exception.handler.SchedulerHandlerException;
import io.perfana.eventscheduler.log.EventLoggerDevNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class EventBroadcasterDefault
implements EventBroadcaster {
    private final List<Event> events;
    private final EventLogger logger;
    private final int continueTestRunParticipantsCount;

    EventBroadcasterDefault(Collection<Event> events, EventLogger logger) {
        this.events = events == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Event>(events));
        this.continueTestRunParticipantsCount = (int)this.events.stream().filter(Event::isContinueOnKeepAliveParticipant).count();
        this.logger = logger == null ? EventLoggerDevNull.INSTANCE : logger;
    }

    @Override
    public void broadcastBeforeTest() {
        this.logger.info("broadcast before test event");
        this.events.forEach(this.catchExceptionWrapper(Event::beforeTest));
    }

    @Override
    public void broadcastStartTest() {
        this.logger.info("broadcast start test event");
        this.events.forEach(this.catchExceptionWrapper(Event::startTest));
    }

    @Override
    public void broadcastAfterTest() {
        this.logger.info("broadcast after test event");
        this.events.forEach(this.catchExceptionWrapper(Event::afterTest));
    }

    @Override
    public void broadcastKeepAlive() throws SchedulerHandlerException {
        this.logger.debug("broadcast keep alive event");
        ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue<Throwable>();
        this.events.forEach(this.catchExceptionWrapper(Event::keepAlive, exceptions));
        this.logger.debug("Keep Alive found exceptions: " + exceptions);
        this.throwAbortOrKillWitchOrStopTestRunException(exceptions, this.continueTestRunParticipantsCount, this.logger);
    }

    @Override
    public void broadcastAbortTest() {
        this.logger.debug("broadcast abort test event");
        this.events.forEach(this.catchExceptionWrapper(Event::abortTest));
    }

    @Override
    public void broadcastCustomEvent(CustomEvent scheduleEvent) {
        this.logger.info("broadcast " + scheduleEvent.getName() + " custom event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.customEvent(scheduleEvent)));
    }

    @Override
    public List<EventCheck> broadcastCheck() {
        this.logger.info("broadcast check test");
        return this.events.stream().map(Event::check).collect(Collectors.toList());
    }

    @Override
    public void shutdownAndWaitAllTasksDone(long timeoutSeconds) {
        this.logger.debug("shutdown broadcaster called, is noop in this implementation.");
    }

    private Consumer<Event> catchExceptionWrapper(Consumer<Event> consumer) throws SchedulerHandlerException {
        return this.catchExceptionWrapper(consumer, null);
    }

    private Consumer<Event> catchExceptionWrapper(Consumer<Event> consumer, Queue<Throwable> errors) {
        return event -> {
            block6: {
                try {
                    consumer.accept((Event)event);
                }
                catch (SchedulerHandlerException e) {
                    if (errors != null) {
                        errors.add(e);
                    }
                }
                catch (Exception e) {
                    String message = "exception in event (" + event.getName() + ")";
                    if (this.logger != null) {
                        this.logger.error(message, e);
                    } else {
                        System.err.printf("exception found (note: better provide a logger): %s %s", message, e.getMessage());
                    }
                    if (errors == null) break block6;
                    errors.add(e);
                }
            }
        };
    }
}

