/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api;

import io.perfana.eventscheduler.api.EventGeneratorMetaProperty;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EventGeneratorProperties {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\n");
    private static final String PREFIX_META_PROPERTY = "@";
    private final Map<String, String> properties;
    private Map<String, String> metaProperties;

    public EventGeneratorProperties(Map<String, String> props) {
        Map<String, String> propsMap = props.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(PREFIX_META_PROPERTY)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> metaMap = props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(PREFIX_META_PROPERTY)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(PREFIX_META_PROPERTY.length()), Map.Entry::getValue));
        Set<String> metaOptions = metaMap.keySet();
        if (!metaOptions.stream().allMatch(EventGeneratorMetaProperty::isEnumValue)) {
            String availableOptions = Arrays.stream(EventGeneratorMetaProperty.values()).map(Enum::name).collect(Collectors.joining(", "));
            throw new EventSchedulerRuntimeException(String.format("Contains unknown meta option: %s, availabe: %s", metaOptions, availableOptions));
        }
        this.properties = Collections.unmodifiableMap(propsMap);
        this.metaProperties = Collections.unmodifiableMap(metaMap);
    }

    public EventGeneratorProperties() {
        this.properties = Collections.emptyMap();
    }

    public EventGeneratorProperties(String propsAsText) {
        this(Collections.unmodifiableMap(EventGeneratorProperties.createGeneratorSettings(propsAsText)));
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getMetaProperty(String name) {
        return this.metaProperties.get(name);
    }

    private static Map<String, String> createGeneratorSettings(String generatorSettingsAsText) {
        return PATTERN_NEW_LINE.splitAsStream(generatorSettingsAsText).map(line -> line.split("=")).filter(split -> ((String[])split).length == 2).filter(split -> split[0] != null && split[1] != null).collect(Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));
    }

    public static boolean hasLinesThatStartWithMetaPropertyPrefix(String text) {
        return PATTERN_NEW_LINE.splitAsStream(text).map(String::trim).anyMatch(line -> line.startsWith(PREFIX_META_PROPERTY));
    }

    public String toString() {
        return "GeneratorProperties{properties=" + this.properties + ", metaProperties=" + this.metaProperties + "}";
    }
}

