/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.api.config;

import net.jcip.annotations.Immutable;

@Immutable
public class EventContext {
    private final String name;
    private final String eventFactory;
    private final boolean enabled;
    private final String scheduleScript;
    private final boolean readyForStartParticipant;
    private final boolean continueOnKeepAliveParticipant;

    protected EventContext(EventContext context, String eventFactory) {
        this.name = context.name;
        this.eventFactory = eventFactory;
        this.enabled = context.enabled;
        this.scheduleScript = context.scheduleScript;
        this.readyForStartParticipant = context.readyForStartParticipant;
        this.continueOnKeepAliveParticipant = context.continueOnKeepAliveParticipant;
    }

    @Deprecated
    protected EventContext(EventContext context, String eventFactory, boolean isReadyForStartParticipant) {
        this(context, eventFactory);
    }

    protected static EventContextBuilder builder() {
        return new EventContextBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getEventFactory() {
        return this.eventFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getScheduleScript() {
        return this.scheduleScript;
    }

    public boolean isReadyForStartParticipant() {
        return this.readyForStartParticipant;
    }

    public boolean isContinueOnKeepAliveParticipant() {
        return this.continueOnKeepAliveParticipant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContext)) {
            return false;
        }
        EventContext other = (EventContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isReadyForStartParticipant() != other.isReadyForStartParticipant()) {
            return false;
        }
        if (this.isContinueOnKeepAliveParticipant() != other.isContinueOnKeepAliveParticipant()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$eventFactory = this.getEventFactory();
        String other$eventFactory = other.getEventFactory();
        if (this$eventFactory == null ? other$eventFactory != null : !this$eventFactory.equals(other$eventFactory)) {
            return false;
        }
        String this$scheduleScript = this.getScheduleScript();
        String other$scheduleScript = other.getScheduleScript();
        return !(this$scheduleScript == null ? other$scheduleScript != null : !this$scheduleScript.equals(other$scheduleScript));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isReadyForStartParticipant() ? 79 : 97);
        result = result * 59 + (this.isContinueOnKeepAliveParticipant() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $eventFactory = this.getEventFactory();
        result = result * 59 + ($eventFactory == null ? 43 : $eventFactory.hashCode());
        String $scheduleScript = this.getScheduleScript();
        result = result * 59 + ($scheduleScript == null ? 43 : $scheduleScript.hashCode());
        return result;
    }

    public String toString() {
        return "EventContext(name=" + this.getName() + ", eventFactory=" + this.getEventFactory() + ", enabled=" + this.isEnabled() + ", scheduleScript=" + this.getScheduleScript() + ", readyForStartParticipant=" + this.isReadyForStartParticipant() + ", continueOnKeepAliveParticipant=" + this.isContinueOnKeepAliveParticipant() + ")";
    }

    public EventContext(String name, String eventFactory, boolean enabled, String scheduleScript, boolean readyForStartParticipant, boolean continueOnKeepAliveParticipant) {
        this.name = name;
        this.eventFactory = eventFactory;
        this.enabled = enabled;
        this.scheduleScript = scheduleScript;
        this.readyForStartParticipant = readyForStartParticipant;
        this.continueOnKeepAliveParticipant = continueOnKeepAliveParticipant;
    }

    protected static class EventContextBuilder {
        private String name;
        private String eventFactory;
        private boolean enabled;
        private String scheduleScript;
        private boolean readyForStartParticipant;
        private boolean continueOnKeepAliveParticipant;

        EventContextBuilder() {
        }

        public EventContextBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EventContextBuilder eventFactory(String eventFactory) {
            this.eventFactory = eventFactory;
            return this;
        }

        public EventContextBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public EventContextBuilder scheduleScript(String scheduleScript) {
            this.scheduleScript = scheduleScript;
            return this;
        }

        public EventContextBuilder readyForStartParticipant(boolean readyForStartParticipant) {
            this.readyForStartParticipant = readyForStartParticipant;
            return this;
        }

        public EventContextBuilder continueOnKeepAliveParticipant(boolean continueOnKeepAliveParticipant) {
            this.continueOnKeepAliveParticipant = continueOnKeepAliveParticipant;
            return this;
        }

        public EventContext build() {
            return new EventContext(this.name, this.eventFactory, this.enabled, this.scheduleScript, this.readyForStartParticipant, this.continueOnKeepAliveParticipant);
        }

        public String toString() {
            return "EventContext.EventContextBuilder(name=" + this.name + ", eventFactory=" + this.eventFactory + ", enabled=" + this.enabled + ", scheduleScript=" + this.scheduleScript + ", readyForStartParticipant=" + this.readyForStartParticipant + ", continueOnKeepAliveParticipant=" + this.continueOnKeepAliveParticipant + ")";
        }
    }
}

