/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler.generator;

import io.perfana.eventscheduler.api.EventGeneratorFactory;
import io.perfana.eventscheduler.api.EventLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class EventGeneratorFactoryProvider {
    private final Map<String, EventGeneratorFactory> generatorFactories;
    private final EventLogger logger;

    EventGeneratorFactoryProvider(Map<String, EventGeneratorFactory> generatorFactories, EventLogger logger) {
        this.generatorFactories = Collections.unmodifiableMap(new HashMap<String, EventGeneratorFactory>(generatorFactories));
        this.logger = logger;
    }

    public static EventGeneratorFactoryProvider createInstanceFromClasspath(EventLogger logger) {
        return EventGeneratorFactoryProvider.createInstanceFromClasspath(logger, null);
    }

    public static EventGeneratorFactoryProvider createInstanceFromClasspath(EventLogger logger, ClassLoader classLoader) {
        ServiceLoader<EventGeneratorFactory> generatorFactoryLoader = classLoader == null ? ServiceLoader.load(EventGeneratorFactory.class) : ServiceLoader.load(EventGeneratorFactory.class, classLoader);
        HashMap<String, EventGeneratorFactory> factories = new HashMap<String, EventGeneratorFactory>();
        for (EventGeneratorFactory generatorFactory : generatorFactoryLoader) {
            String generatorName = generatorFactory.getClass().getName();
            logger.info("registering EventScheduleGeneratorFactory: " + generatorName);
            factories.put(generatorName, generatorFactory);
        }
        return new EventGeneratorFactoryProvider(factories, logger);
    }

    public EventGeneratorFactory find(String generatorClassname) {
        return this.generatorFactories.get(generatorClassname);
    }
}

