/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark;

import io.perfmark.NoopMarkHolderProvider;
import io.perfmark.Tag;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkHolderProvider;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.Marker;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerfMarkStorage {
    private static final long initNanoTime;
    private static final List<String> FALLBACK_MARK_HOLDERS;
    static final long NO_THREAD_ID = -1L;
    static final String NO_THREAD_NAME = "(unknownThread)";
    static final ConcurrentMap<MarkHolderRef, Reference<? extends Thread>> allMarkHolders;
    private static final ThreadLocal<MarkHolder> localMarkHolder;
    static final MarkHolderProvider markHolderProvider;
    private static final Logger logger;

    public static long getInitNanoTime() {
        return initNanoTime;
    }

    public static List<MarkList> read() {
        MarkHolderRef.cleanQueue(allMarkHolders);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<Long> markHolderIds = new ArrayList<Long>();
        ArrayList<MarkHolder> markHolders = new ArrayList<MarkHolder>();
        for (Map.Entry entry : allMarkHolders.entrySet()) {
            MarkHolder mh = (MarkHolder)((MarkHolderRef)entry.getKey()).get();
            if (mh == null) continue;
            Thread writer = (Thread)((Reference)entry.getValue()).get();
            markHolders.add(mh);
            markHolderIds.add(((MarkHolderRef)entry.getKey()).markHolderId);
            threads.add(writer);
        }
        assert (markHolders.size() == threads.size());
        ArrayList<MarkList> markLists = new ArrayList<MarkList>(markHolders.size());
        long noThreadIds = -1L;
        for (int i = 0; i < markHolders.size(); ++i) {
            long threadId;
            String threadName;
            Thread writer = (Thread)threads.get(i);
            if (writer == null) {
                --noThreadIds;
                threadName = NO_THREAD_NAME;
            } else {
                threadId = writer.getId();
                threadName = writer.getName();
            }
            boolean readerIsWriter = Thread.currentThread() == writer;
            markLists.add(MarkList.newBuilder().setMarks(((MarkHolder)markHolders.get(i)).read(readerIsWriter)).setThreadName(threadName).setThreadId(threadId).setMarkListId(((Long)markHolderIds.get(i)).longValue()).build());
        }
        return Collections.unmodifiableList(markLists);
    }

    static void startAnyways(long gen, String taskName, Tag tag) {
        localMarkHolder.get().start(gen, taskName, tag.tagName, tag.tagId, System.nanoTime());
    }

    static void startAnyways(long gen, Marker marker, Tag tag) {
        localMarkHolder.get().start(gen, marker, tag.tagName, tag.tagId, System.nanoTime());
    }

    static void startAnyways(long gen, String taskName) {
        localMarkHolder.get().start(gen, taskName, System.nanoTime());
    }

    static void startAnyways(long gen, Marker marker) {
        localMarkHolder.get().start(gen, marker, System.nanoTime());
    }

    static void stopAnyways(long gen, String taskName, Tag tag) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, tag.tagName, tag.tagId, nanoTime);
    }

    static void stopAnyways(long gen, Marker marker, Tag tag) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, marker, tag.tagName, tag.tagId, nanoTime);
    }

    static void stopAnyways(long gen, String taskName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, nanoTime);
    }

    static void stopAnyways(long gen, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, marker, nanoTime);
    }

    static void eventAnyways(long gen, String eventName, Tag tag) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, tag.tagName, tag.tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, Marker marker, Tag tag) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, marker, tag.tagName, tag.tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, String eventName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, nanoTime, 0L);
    }

    static void eventAnyways(long gen, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, marker, nanoTime, 0L);
    }

    static void linkAnyways(long gen, long linkId, Marker marker) {
        localMarkHolder.get().link(gen, linkId, marker);
    }

    static void resetForTest() {
        localMarkHolder.get().resetForTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> List<T> getLoadable(List<? super Throwable> errors, Class<T> clz, List<? extends String> fallbackClassNames, ClassLoader cl) {
        LinkedHashMap<Class<T>, T> loadables = new LinkedHashMap<Class<T>, T>();
        ArrayList<ServiceConfigurationError> serviceLoaderErrors = new ArrayList<ServiceConfigurationError>();
        try {
            ServiceLoader<T> loader = ServiceLoader.load(clz, cl);
            Iterator<T> iterator = loader.iterator();
            for (int i = 0; i < 10 && serviceLoaderErrors.size() < 10; ++i) {
                try {
                    if (iterator.hasNext()) {
                        T next = iterator.next();
                        Class<T> subClz = next.getClass().asSubclass(clz);
                        if (loadables.containsKey(subClz)) continue;
                        loadables.put(subClz, next);
                        continue;
                    }
                    break;
                }
                catch (ServiceConfigurationError sce) {
                    Throwable last;
                    if (!serviceLoaderErrors.isEmpty() && PerfMarkStorage.errorsEqual(sce, last = (Throwable)serviceLoaderErrors.get(serviceLoaderErrors.size() - 1))) continue;
                    serviceLoaderErrors.add(sce);
                }
            }
        }
        catch (ServiceConfigurationError sce) {
            serviceLoaderErrors.add(sce);
        }
        finally {
            errors.addAll(serviceLoaderErrors);
        }
        for (String string : fallbackClassNames) {
            try {
                Class<?> fallbackClz = Class.forName(string, true, cl);
                if (loadables.containsKey(fallbackClz)) continue;
                Class<T> subClz = fallbackClz.asSubclass(clz);
                loadables.put(subClz, subClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        return Collections.unmodifiableList(new ArrayList(loadables.values()));
    }

    private static boolean errorsEqual(Throwable t1, Throwable t2) {
        String msg2;
        String msg1;
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (t1.getClass() == t2.getClass() && ((msg1 = t1.getMessage()) == (msg2 = t2.getMessage()) || msg1 != null && msg1.equals(msg2)) && Arrays.equals(t1.getStackTrace(), t2.getStackTrace())) {
            return PerfMarkStorage.errorsEqual(t1.getCause(), t2.getCause());
        }
        return false;
    }

    private PerfMarkStorage() {
        throw new AssertionError((Object)"nope");
    }

    static {
        Level level;
        initNanoTime = System.nanoTime();
        FALLBACK_MARK_HOLDERS = Collections.unmodifiableList(Arrays.asList("io.perfmark.java9.SecretVarHandleMarkHolderProvider$VarHandleMarkHolderProvider", "io.perfmark.java6.SecretSynchronizedMarkHolderProvider$SynchronizedMarkHolderProvider"));
        allMarkHolders = new ConcurrentHashMap<MarkHolderRef, Reference<? extends Thread>>();
        localMarkHolder = new MarkHolderThreadLocal();
        ArrayList errors = new ArrayList();
        List<MarkHolderProvider> markHolders = PerfMarkStorage.getLoadable(errors, MarkHolderProvider.class, FALLBACK_MARK_HOLDERS, PerfMarkStorage.class.getClassLoader());
        if (markHolders.isEmpty()) {
            markHolderProvider = new NoopMarkHolderProvider();
            level = Level.WARNING;
        } else {
            markHolderProvider = markHolders.get(0);
            level = Level.FINE;
        }
        logger = Logger.getLogger(PerfMarkStorage.class.getName());
        logger.log(level, "Using {0}", new Object[]{markHolderProvider.getClass()});
        for (Throwable error : errors) {
            logger.log(level, "Error encountered loading mark holder", error);
        }
    }

    private static final class MarkHolderRef
    extends WeakReference<MarkHolder> {
        private static final ReferenceQueue<MarkHolder> markHolderRefQueue = new ReferenceQueue();
        private static final AtomicLong markHolderIdAllocator = new AtomicLong();
        final long markHolderId = markHolderIdAllocator.incrementAndGet();

        MarkHolderRef(MarkHolder holder) {
            super(holder, markHolderRefQueue);
        }

        static void cleanQueue(Map<MarkHolderRef, ?> allSpans) {
            Reference<MarkHolder> ref;
            while ((ref = markHolderRefQueue.poll()) != null) {
                ref.clear();
                allSpans.remove(ref);
            }
        }
    }

    private static final class MarkHolderThreadLocal
    extends ThreadLocal<MarkHolder> {
        MarkHolderThreadLocal() {
        }

        @Override
        protected MarkHolder initialValue() {
            MarkHolderRef.cleanQueue(allMarkHolders);
            MarkHolder holder = markHolderProvider.create();
            MarkHolderRef ref = new MarkHolderRef(holder);
            WeakReference<Thread> writer = new WeakReference<Thread>(Thread.currentThread());
            allMarkHolders.put(ref, writer);
            return holder;
        }
    }
}

