/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.Generator;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkList;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Storage {
    private static final ConcurrentMap<Object, Reference<MarkHolder>> allMarkHolders = new ConcurrentHashMap<Object, Reference<MarkHolder>>();

    public static long getInitNanoTime() {
        return Generator.INIT_NANO_TIME;
    }

    public static List<MarkList> read() {
        ArrayList markLists = new ArrayList();
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            MarkHolder markHolder = (MarkHolder)ref.get();
            if (markHolder == null) {
                it.remove();
                continue;
            }
            markHolder.read(markLists);
        }
        HashSet<Long> markRecorderIds = new HashSet<Long>(markLists.size());
        for (MarkList list : markLists) {
            if (markRecorderIds.add(list.getMarkRecorderId())) continue;
            throw new IllegalStateException("Duplicate MarkRecorder IDs in MarkHolders " + list.getMarkRecorderId());
        }
        return Collections.unmodifiableList(markLists);
    }

    public static void resetForThread() {
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            MarkHolder holder = (MarkHolder)ref.get();
            if (holder == null) {
                it.remove();
                continue;
            }
            holder.resetForThread();
        }
    }

    public static void resetForAll() {
        Iterator it = allMarkHolders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Reference ref = (Reference)entry.getValue();
            MarkHolder holder = (MarkHolder)ref.get();
            if (holder == null) {
                it.remove();
                continue;
            }
            if (ref instanceof SoftReference) {
                entry.setValue(new WeakReference<MarkHolder>(holder));
            }
            holder.resetForAll();
        }
    }

    public static void registerMarkHolder(MarkHolder markHolder) {
        if (markHolder == null) {
            throw new NullPointerException("markHolder");
        }
        allMarkHolders.put(new Object(), new SoftReference<MarkHolder>(markHolder));
    }

    public static void unregisterMarkHolder(MarkHolder markHolder) {
        if (markHolder == null) {
            throw new NullPointerException("markHolder");
        }
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            MarkHolder holder = (MarkHolder)ref.get();
            if (holder == null) {
                it.remove();
                continue;
            }
            if (holder != markHolder) continue;
            it.remove();
            break;
        }
    }

    public static MarkList readForTest() {
        List<MarkList> lists = Storage.read();
        for (MarkList list : lists) {
            if (list.getThreadId() != Thread.currentThread().getId()) continue;
            return list;
        }
        return null;
    }

    private Storage() {
    }
}

