/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.cli.app;

import io.permazen.Permazen;
import io.permazen.SessionMode;
import io.permazen.app.AbstractMain;
import io.permazen.cli.CliSession;
import io.permazen.cli.Console;
import io.permazen.core.Database;
import io.permazen.schema.SchemaModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.fusesource.jansi.internal.CLibrary;

public class Main
extends AbstractMain {
    public static final String HISTORY_FILE = ".permazen_history";
    private File schemaFile;
    private File historyFile = new File(new File(System.getProperty("user.home")), ".permazen_history");
    private SessionMode mode = SessionMode.PERMAZEN;
    private final ArrayList<String> execCommands = new ArrayList();
    private final ArrayList<String> execFiles = new ArrayList();
    private boolean keyboardInput = Main.isWindows() || CLibrary.isatty((int)0) != 0;
    private boolean batchMode = !this.keyboardInput;

    protected boolean parseOption(String option, ArrayDeque<String> params) {
        switch (option) {
            case "--schema-file": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.schemaFile = new File(params.removeFirst());
                break;
            }
            case "--command": 
            case "-c": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.execCommands.add(params.removeFirst());
                break;
            }
            case "--history-file": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.historyFile = new File(params.removeFirst());
                break;
            }
            case "--file": 
            case "-f": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.execFiles.add(params.removeFirst());
                break;
            }
            case "--core-mode": {
                this.mode = SessionMode.CORE_API;
                break;
            }
            case "--kv-mode": {
                this.mode = SessionMode.KEY_VALUE;
                break;
            }
            case "--batch": 
            case "-n": {
                this.batchMode = true;
                if (!Main.isWindows()) break;
                this.keyboardInput = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        Console console0;
        Permazen jdb;
        ArrayDeque<String> params = new ArrayDeque<String>(Arrays.asList(args));
        int result = this.parseOptions(params);
        if (result != -1) {
            return result;
        }
        switch (params.size()) {
            case 0: {
                break;
            }
            default: {
                this.usageError();
                return 1;
            }
        }
        SchemaModel schemaModel = null;
        if (this.schemaFile != null) {
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.schemaFile));){
                schemaModel = SchemaModel.fromXML((InputStream)input);
            }
            catch (Exception e) {
                System.err.println(this.getName() + ": can't load schema from `" + this.schemaFile + "': " + e.getMessage());
                if (!this.verbose) return 1;
                e.printStackTrace(System.err);
                return 1;
            }
        }
        Database db = this.startupKVDatabase();
        Permazen permazen = jdb = this.schemaClasses != null ? this.getPermazenFactory(db).newPermazen() : null;
        if (jdb != null) {
            if (schemaModel != null) {
                if (!schemaModel.equals((Object)jdb.getSchemaModel())) {
                    System.err.println(this.getName() + ": schema from `" + this.schemaFile + "' conflicts with schema generated from scanned classes");
                    System.err.println(schemaModel.differencesFrom(jdb.getSchemaModel()));
                    return 1;
                }
            } else {
                schemaModel = jdb.getSchemaModel();
            }
        }
        if (jdb == null && this.mode.equals((Object)SessionMode.PERMAZEN)) {
            System.err.println(this.getName() + ": entering core API mode because no Java model classes were specified");
            this.mode = SessionMode.CORE_API;
        }
        switch (this.mode) {
            case KEY_VALUE: {
                console0 = new Console(db.getKVDatabase(), (InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out);
                break;
            }
            case CORE_API: {
                console0 = new Console(db, (InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out);
                break;
            }
            case PERMAZEN: {
                console0 = new Console(jdb, (InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out);
                break;
            }
            default: {
                console0 = null;
                assert (false);
                break;
            }
        }
        try (Console console = console0;){
            if (this.keyboardInput && !this.batchMode) {
                console.setHistoryFile(this.historyFile);
            }
            CliSession session = console.getSession();
            session.setDatabaseDescription(this.getDatabaseDescription());
            session.setReadOnly(this.readOnly);
            session.setVerbose(this.verbose);
            session.setSchemaModel(schemaModel);
            session.setSchemaVersion(this.schemaVersion);
            session.setAllowNewSchema(this.allowNewSchema);
            session.loadFunctionsFromClasspath();
            session.loadCommandsFromClasspath();
            for (String filename : this.execFiles) {
                File file = new File(filename);
                try {
                    FileInputStream input;
                    block46: {
                        int n;
                        input = new FileInputStream(file);
                        try {
                            if (this.parseAndExecuteCommands(console, new InputStreamReader(input), file.getName())) break block46;
                            n = 1;
                        }
                        catch (Throwable throwable) {
                            try {
                                ((InputStream)input).close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        ((InputStream)input).close();
                        return n;
                    }
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    session.getWriter().println("Error: error opening " + file.getName() + ": " + e);
                    int n = 1;
                    if (console == null) return n;
                    console.close();
                    return n;
                }
            }
            for (String command : this.execCommands) {
                if (this.parseAndExecuteCommands(console, new StringReader(command), null)) continue;
                int n = 1;
                return n;
            }
            if (!this.keyboardInput && !this.parseAndExecuteCommands(console, new InputStreamReader(System.in), "(stdin)")) {
                int n = 1;
                return n;
            }
            if (this.keyboardInput && !this.batchMode) {
                console.run();
            }
            this.shutdownKVDatabase();
            int n = 0;
            return n;
        }
    }

    private boolean parseAndExecuteCommands(Console console, Reader input, String inputDescription) {
        try {
            return console.runNonInteractive(input, inputDescription);
        }
        catch (IOException e) {
            console.getSession().getWriter().println("Error: error reading " + inputDescription + ": " + e);
            return false;
        }
    }

    protected String getName() {
        return "permazen";
    }

    protected void usageMessage() {
        System.err.println("Usage:");
        System.err.println("  " + this.getName() + " [options]");
        System.err.println("Options:");
        this.outputFlags(new String[][]{{"--history-file file", "Specify file for CLI command history (default ~/.permazen_history)"}, {"--schema-file file", "Load core database schema from XML file"}, {"--core-mode", "Force core API mode (default if neither Java model classes nor schema are provided)"}, {"--kv-mode", "Force key/value mode"}, {"--command, -c command", "Execute the given command (may be repeated)"}, {"--file, -f file", "Read and execute commands from `file' (may be repeated)"}, {"--batch, -n", "Batch mode: do not start the interactive CLI console"}});
    }

    public static void main(String[] args) throws Exception {
        new Main().doMain(args);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
    }
}

