/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import java.io.IOException;
import java.io.OutputStream;

abstract class AbstractLazyOutputStream
extends OutputStream {
    private OutputStream os;

    AbstractLazyOutputStream() {
    }

    @Override
    public void close() throws IOException {
        this.loadOs();
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.loadOs();
        this.os.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.loadOs();
        this.os.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.loadOs();
        this.os.write(b);
    }

    protected void loadOs() throws IOException {
        if (this.os == null) {
            this.os = this.retrieveOs();
        }
    }

    protected abstract OutputStream retrieveOs() throws IOException;
}

