/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.HttpExchanges;
import com.github.xgp.http.server.InternalHttpExchange;
import com.github.xgp.http.server.Request;
import com.github.xgp.http.server.Response;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;

@FunctionalInterface
public interface Handler
extends HttpHandler {
    @Override
    default public void handle(HttpExchange exchange) throws IOException {
        InternalHttpExchange ex = (InternalHttpExchange)exchange;
        Request request = new Request(ex);
        Response response = new Response(ex);
        this.handle(request, response);
        if (response.redirect() != null) {
            HttpExchanges.sendRedirect(ex, request.uri().resolve(response.redirect()));
            return;
        }
        if (response.body() != null) {
            if (response.transformer() == null) {
                response.transformer(ex.getTransformer());
            }
            if (response.contentType() == null) {
                response.contentType(response.transformer().contentType());
            }
            if (response.status() == 0) {
                response.status(200);
            }
            ex.sendResponseHeaders(response.status(), 0L);
            response.transformer().render(response.body(), response);
        }
        response.stream().close();
        ex.close();
    }

    public void handle(Request var1, Response var2) throws IOException;
}

