/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.AbstractLazyOutputStream;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public final class HttpExchanges {
    private static final Logger log = Logger.getLogger(HttpExchanges.class.getName());
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private static final ThreadLocal<DateFormat> dateFormatRfc1123 = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
            df.setTimeZone(GMT);
            return df;
        }
    };
    private static final ThreadLocal<DateFormat> dateFormatRfc1036 = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH);
            df.setTimeZone(GMT);
            return df;
        }
    };
    private static final ThreadLocal<DateFormat> dateFormatAsctime = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);
            df.setTimeZone(GMT);
            return df;
        }
    };
    private static final List<ThreadLocal<DateFormat>> dateFormatsRfc2616;
    static final ThreadLocal<Object> abortImmediately;

    private HttpExchanges() {
    }

    static void resetThread() {
        dateFormatRfc1123.remove();
        dateFormatRfc1036.remove();
        dateFormatAsctime.remove();
        abortImmediately.remove();
    }

    public static URI getRequestUri(HttpExchange ex) {
        URI base;
        String host = ex.getRequestHeaders().getFirst("Host");
        if (host == null) {
            log.warning("Request did not provide Host header, using 'localhost' as hostname");
            int port = ex.getHttpContext().getServer().getAddress().getPort();
            host = "localhost:" + port;
        }
        String protocol = ex.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        try {
            base = new URI(protocol, host, "/", null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        URI requestedUri = ex.getRequestURI();
        requestedUri = base.resolve(requestedUri);
        log.log(Level.FINER, "Resolved original URI to: {0}", requestedUri);
        return requestedUri;
    }

    static void respondToHead(HttpExchange ex, int code, String contentType) throws IOException {
        ex.getResponseHeaders().set("Transfer-Encoding", "chunked");
        HttpExchanges.respond(ex, code, contentType, null);
    }

    static void cannedRespond(HttpExchange ex, int code, String response) throws IOException {
        HttpExchanges.cannedRespond(ex, code, "text/plain", response.toString());
    }

    static void cannedRespond(HttpExchange ex, int code, String template, Object ... params) throws IOException {
        HttpExchanges.cannedRespond(ex, code, "text/plain", String.format(template, params));
    }

    private static void cannedRespond(HttpExchange ex, int code, String contentType, String response) throws IOException {
        if ("HEAD".equals(ex.getRequestMethod())) {
            HttpExchanges.respondToHead(ex, code, contentType);
        } else {
            HttpExchanges.respond(ex, code, contentType, response.getBytes(ENCODING));
        }
    }

    static void startResponse(HttpExchange ex, int code, String contentType, boolean hasBody) throws IOException {
        log.finest("Starting response");
        if (contentType != null) {
            ex.getResponseHeaders().set("Content-Type", contentType);
        }
        if (!hasBody) {
            ex.sendResponseHeaders(code, -1L);
        } else {
            ex.sendResponseHeaders(code, 0L);
        }
    }

    static void respond(HttpExchange ex, int code, String contentType, byte[] response) throws IOException {
        HttpExchanges.startResponse(ex, code, contentType, response != null);
        if (response != null) {
            OutputStream responseBody = ex.getResponseBody();
            log.finest("before writing response");
            responseBody.write(response);
            responseBody.flush();
            responseBody.close();
            log.finest("after writing response");
        }
        ex.close();
        log.finest("after closing exchange");
    }

    public static void sendRedirect(HttpExchange ex, URI location) throws IOException {
        ex.getResponseHeaders().set("Location", location.toString());
        HttpExchanges.respond(ex, 303, null, null);
    }

    static List<String> splitHeaderValues(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> parsed = new ArrayList<String>(values.size());
        for (String value : values) {
            String[] parts;
            for (String part : parts = value.split(",", -1)) {
                parsed.add(part.trim());
            }
        }
        return Collections.unmodifiableList(parsed);
    }

    public static void enableCompressionIfSupported(HttpExchange ex) throws IOException {
        List<String> encodings = HttpExchanges.splitHeaderValues((List<String>)ex.getRequestHeaders().get("Accept-Encoding"));
        if (encodings == null) {
            return;
        }
        if (encodings.contains("gzip")) {
            log.finer("Enabling gzip compression for response");
            ex.getResponseHeaders().set("Content-Encoding", "gzip");
            final OutputStream os = ex.getResponseBody();
            ex.setStreams(null, new AbstractLazyOutputStream(){

                @Override
                protected OutputStream retrieveOs() throws IOException {
                    return new GZIPOutputStream(os);
                }
            });
        }
    }

    public static Date getIfModifiedSince(HttpExchange ex) {
        String ifModifiedSince = ex.getRequestHeaders().getFirst("If-Modified-Since");
        if (ifModifiedSince == null) {
            return null;
        }
        for (ThreadLocal<DateFormat> threadLocal : dateFormatsRfc2616) {
            try {
                return threadLocal.get().parse(ifModifiedSince);
            }
            catch (ParseException e) {
                log.log(Level.FINE, "Exception when parsing If-Modified-Since", e);
            }
        }
        log.log(Level.WARNING, "Could not parse If-Modified-Since: {0}", ifModifiedSince);
        return null;
    }

    public static boolean headersSent(HttpExchange ex) {
        return ex.getResponseHeaders().getFirst("Date") != null;
    }

    public static void setLastModified(HttpExchange ex, Date lastModified) {
        ex.getResponseHeaders().set("Last-Modified", dateFormatRfc1123.get().format(lastModified));
    }

    public static Map<String, List<String>> parseQueryParameters(HttpExchange ex, Charset charset) {
        String queryString = ex.getRequestURI().getRawQuery();
        if (queryString == null || queryString.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, LinkedList<String>> parsedParams = new TreeMap<String, LinkedList<String>>();
        for (String param : queryString.split("&")) {
            String[] parts = param.split("=", 2);
            String key = parts[0];
            String value = parts.length == 2 ? parts[1] : "";
            try {
                key = URLDecoder.decode(key, charset.name());
                value = URLDecoder.decode(value, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
            LinkedList<String> values = (LinkedList<String>)parsedParams.get(key);
            if (values == null) {
                values = new LinkedList<String>();
                parsedParams.put(key, values);
            }
            values.add(value);
        }
        for (Map.Entry entry : parsedParams.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(parsedParams);
    }

    static {
        abortImmediately = new ThreadLocal();
        ArrayList<ThreadLocal<DateFormat>> tmpList = new ArrayList<ThreadLocal<DateFormat>>();
        tmpList.add(dateFormatRfc1123);
        tmpList.add(dateFormatRfc1036);
        tmpList.add(dateFormatAsctime);
        dateFormatsRfc2616 = Collections.unmodifiableList(tmpList);
    }
}

