/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.Route;
import com.github.xgp.http.server.Transformer;
import com.github.xgp.http.server.Transformers;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public class InternalHttpExchange
extends HttpExchange {
    private final HttpExchange ex;
    private final Route route;
    private final Map<String, Transformer> transformers;

    InternalHttpExchange(HttpExchange ex, Route route, Map<String, Transformer> transformers) {
        this.ex = ex;
        this.route = route;
        this.transformers = transformers;
    }

    public Route getRoute() {
        return this.route;
    }

    public Transformer getTransformer() {
        return this.route.getTransformer().orElseGet(() -> this.transformerFor(this.getResponseHeaders().getFirst("Content-Type")).orElse(Transformers.string()));
    }

    public Optional<Transformer> transformerFor(String contentType) {
        return Optional.ofNullable(this.transformers.get(contentType));
    }

    @Override
    public Headers getRequestHeaders() {
        return this.ex.getRequestHeaders();
    }

    @Override
    public Headers getResponseHeaders() {
        return this.ex.getResponseHeaders();
    }

    @Override
    public URI getRequestURI() {
        return this.ex.getRequestURI();
    }

    @Override
    public String getRequestMethod() {
        return this.ex.getRequestMethod();
    }

    @Override
    public HttpContext getHttpContext() {
        return this.ex.getHttpContext();
    }

    @Override
    public void close() {
        this.ex.close();
    }

    @Override
    public InputStream getRequestBody() {
        return this.ex.getRequestBody();
    }

    @Override
    public OutputStream getResponseBody() {
        return this.ex.getResponseBody();
    }

    @Override
    public void sendResponseHeaders(int rCode, long responseLength) throws IOException {
        this.ex.sendResponseHeaders(rCode, responseLength);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.ex.getRemoteAddress();
    }

    @Override
    public int getResponseCode() {
        return this.ex.getResponseCode();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.ex.getLocalAddress();
    }

    @Override
    public String getProtocol() {
        return this.ex.getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        return this.ex.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.ex.setAttribute(name, value);
    }

    @Override
    public void setStreams(InputStream i, OutputStream o) {
        this.ex.setStreams(i, o);
    }

    @Override
    public HttpPrincipal getPrincipal() {
        return this.ex.getPrincipal();
    }
}

