/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingFilter
extends Filter {
    private static final Logger log = Logger.getLogger(LoggingFilter.class.getName());

    @Override
    public String description() {
        return "Filter that logs requests and responses";
    }

    @Override
    public void doFilter(HttpExchange ex, Filter.Chain chain) throws IOException {
        long startMillis = System.currentTimeMillis();
        try {
            log.fine("beginning");
            this.logRequest(ex);
            log.log(Level.FINE, "Processing context for request is {0}", ex.getHttpContext().getHandler().getClass().getName());
            chain.doFilter(ex);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Unexpected exception during request", e);
            throw e;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unexpected exception during request", e);
            throw e;
        }
        finally {
            this.logResponse(ex);
            LoggingFilter.logDurationInMillis(ex, startMillis);
            log.fine("ending");
        }
    }

    private void logRequest(HttpExchange ex) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Received {1} request to {0}. Headers: '{'{2}'}'", new Object[]{ex.getRequestURI(), ex.getRequestMethod(), this.getLoggableHeaders(ex.getRequestHeaders())});
        }
    }

    private void logResponse(HttpExchange ex) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Responded to {1} request {0}. Headers: '{'{2}'}'", new Object[]{ex.getRequestURI(), ex.getRequestMethod(), this.getLoggableHeaders(ex.getResponseHeaders())});
        }
    }

    private static void logDurationInMillis(HttpExchange ex, long startMillis) {
        log.log(Level.FINE, "Responded to {0} request for {1}. Duration: {2,number,#} ms", new Object[]{ex.getRequestMethod(), ex.getRequestURI(), System.currentTimeMillis() - startMillis});
    }

    String getLoggableHeaders(Headers headers) {
        if (headers.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> me : headers.entrySet()) {
            for (String value : me.getValue()) {
                sb.append(me.getKey());
                sb.append(": ");
                sb.append(value);
                sb.append(", ");
            }
        }
        return sb.substring(0, sb.length() - 2);
    }
}

