/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.HttpExchanges;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class RedirectHandler
implements HttpHandler {
    private final String redirectPath;

    public RedirectHandler(String redirectPath) {
        this.redirectPath = redirectPath;
    }

    @Override
    public void handle(HttpExchange ex) throws IOException {
        URI path;
        if (!ex.getRequestURI().getPath().equals(ex.getHttpContext().getPath())) {
            HttpExchanges.cannedRespond(ex, 404, "404: Not Found.");
            return;
        }
        URI base = HttpExchanges.getRequestUri(ex);
        try {
            path = new URI(this.redirectPath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not construct URI");
        }
        HttpExchanges.sendRedirect(ex, base.resolve(path));
    }
}

