/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.HttpExchanges;
import com.github.xgp.http.server.InternalHttpExchange;
import com.github.xgp.io.Streams;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Request {
    private final InternalHttpExchange exchange;
    private final Map<String, List<String>> queryMap;
    private final Map<String, String> paramMap;

    public Request(InternalHttpExchange exchange) {
        this.exchange = exchange;
        this.queryMap = HttpExchanges.parseQueryParameters(exchange, StandardCharsets.UTF_8);
        this.paramMap = exchange.getRoute().getPathParametersEncoded(exchange.getRequestURI().getPath());
    }

    public HttpExchange exchange() {
        return this.exchange;
    }

    public Object attribute(String name) {
        return this.exchange.getAttribute(name);
    }

    public InetSocketAddress localAddress() {
        return this.exchange.getLocalAddress();
    }

    public HttpPrincipal principal() {
        return this.exchange.getPrincipal();
    }

    public String protocol() {
        return this.exchange.getProtocol();
    }

    public InetSocketAddress remoteAddress() {
        return this.exchange.getRemoteAddress();
    }

    public Headers headers() {
        return this.exchange.getRequestHeaders();
    }

    public List<String> headers(String name) {
        return this.headers().get(name);
    }

    public String header(String name) {
        return this.headers().getFirst(name);
    }

    public List<HttpCookie> cookies() {
        return this.headers("Cookie").stream().flatMap(h -> HttpCookie.parse(h).stream()).collect(Collectors.toList());
    }

    public URI uri() {
        return this.exchange.getRequestURI();
    }

    public String method() {
        return this.exchange.getRequestMethod();
    }

    public InputStream stream() {
        return this.exchange.getRequestBody();
    }

    public String body() {
        try {
            return Streams.readInputStreamToString(this.exchange.getRequestBody(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Map<String, List<String>> queryMap() {
        return this.queryMap;
    }

    public List<String> query(String name) {
        return this.queryMap.get(name);
    }

    public Map<String, String> paramMap() {
        return this.paramMap;
    }

    public String param(String name) {
        return this.paramMap.get(name);
    }
}

