/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.Transformer;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.OutputStream;
import java.net.HttpCookie;

public class Response {
    private final HttpExchange exchange;
    private Object body;
    private Transformer transformer;
    private int status;
    private String redirect;

    public Response(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public HttpExchange exchange() {
        return this.exchange;
    }

    public Headers headers() {
        return this.exchange.getResponseHeaders();
    }

    public Response header(String key, String value) {
        this.headers().add(key, value);
        return this;
    }

    public Response cookie(HttpCookie cookie) {
        this.header("Set-Cookie", cookie.toString());
        return this;
    }

    public Response body(Object body) {
        this.body = body;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public Response transformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public Transformer transformer() {
        return this.transformer;
    }

    public OutputStream stream() {
        return this.exchange.getResponseBody();
    }

    public Response status(int status) {
        this.status = status;
        return this;
    }

    public int status() {
        return this.status;
    }

    public Response contentType(String contentType) {
        this.header("Content-Type", contentType);
        return this;
    }

    public String contentType() {
        return this.headers().getFirst("Content-Type");
    }

    public Response redirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    public String redirect() {
        return this.redirect;
    }
}

