/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.HttpExchanges;
import com.github.xgp.io.Streams;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReverseProxyHandler
implements HttpHandler {
    private static final Set<String> PREDEFINED_HOP_BY_HOP_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
        {
            this.add("Connection");
            this.add("Host");
            this.add("Keep-Alive");
            this.add("Proxy-Authenticate");
            this.add("Proxy-Authorization");
            this.add("TE");
            this.add("Trailers");
            this.add("Transfer-Encoding");
            this.add("Upgrade");
        }
    };
    private static final Logger log = Logger.getLogger(ReverseProxyHandler.class.getName());
    private final URI destinationBase;

    public ReverseProxyHandler(URI destinationBase) {
        if (destinationBase == null) {
            throw new NullPointerException();
        }
        this.destinationBase = destinationBase;
        if (destinationBase.getScheme() == null || destinationBase.getHost() == null || destinationBase.getPath() == null) {
            throw new IllegalArgumentException("destinationBase must contain a scheme, host, and path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange ex) throws IOException {
        InputStream inputStream;
        URI dest = this.computeProxyDestination(ex);
        HttpURLConnection conn = (HttpURLConnection)dest.toURL().openConnection();
        conn.setRequestMethod(ex.getRequestMethod());
        conn.setAllowUserInteraction(false);
        conn.setInstanceFollowRedirects(false);
        conn.setUseCaches(false);
        this.copyRequestHeaders(ex, conn);
        conn.addRequestProperty("X-Forwarded-For", this.getClientIp(ex));
        boolean hasRequestBody = ex.getRequestHeaders().containsKey("Content-Length") || ex.getRequestHeaders().containsKey("Transfer-Encoding");
        conn.setDoOutput(hasRequestBody);
        conn.setDoInput(true);
        if (hasRequestBody) {
            String strContentLength = ex.getRequestHeaders().getFirst("Content-Length");
            long contentLength = -1L;
            if (strContentLength != null) {
                try {
                    contentLength = Long.parseLong(strContentLength);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (contentLength < 0L) {
                conn.setChunkedStreamingMode(-1);
            } else {
                conn.setFixedLengthStreamingMode((int)contentLength);
            }
        } else {
            Authenticator.setDefault(null);
        }
        conn.connect();
        if (hasRequestBody) {
            try {
                Streams.copyStream(ex.getRequestBody(), conn.getOutputStream());
                ex.getRequestBody().close();
                conn.getOutputStream().close();
            }
            catch (IOException e) {
                conn.disconnect();
                throw e;
            }
        }
        InputStream inputStream2 = inputStream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
        if (conn.getResponseCode() == 401 && inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        boolean hasResponseBody = !"HEAD".equalsIgnoreCase(ex.getRequestMethod()) && conn.getResponseCode() / 100 != 1 && conn.getResponseCode() != 204 && conn.getResponseCode() != 304;
        try {
            this.copyResponseHeaders(conn, ex);
            if (!hasResponseBody) {
                ex.sendResponseHeaders(conn.getResponseCode(), -1L);
            } else {
                int contentLength = conn.getContentLength();
                if (contentLength <= 0) {
                    contentLength = 0;
                }
                ex.sendResponseHeaders(conn.getResponseCode(), contentLength);
                Streams.copyStream(inputStream, ex.getResponseBody());
            }
            ex.close();
        }
        finally {
            inputStream.close();
        }
    }

    private URI computeProxyDestination(HttpExchange ex) {
        URI req = HttpExchanges.getRequestUri(ex);
        String basePath = ex.getHttpContext().getPath();
        if (!req.getPath().startsWith(basePath)) {
            throw new AssertionError();
        }
        String lastPartOfPath = req.getPath().substring(basePath.length());
        try {
            return new URI(this.destinationBase.getScheme(), this.destinationBase.getAuthority(), this.destinationBase.getPath() + lastPartOfPath, req.getQuery(), req.getFragment());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String computeReverseProxyDestination(HttpExchange ex, String location) {
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            log.log(Level.INFO, "Could not parse value from header: " + location, e);
            return location;
        }
        URI base = this.destinationBase;
        if (!(base.getScheme().equalsIgnoreCase(uri.getScheme()) && base.getHost().equalsIgnoreCase(uri.getHost()) && base.getPort() == uri.getPort() && uri.getPath() != null && uri.getPath().startsWith(base.getPath()))) {
            return location;
        }
        String lastPartOfPath = uri.getPath().substring(base.getPath().length());
        URI requestUri = HttpExchanges.getRequestUri(ex);
        try {
            return new URI(requestUri.getScheme(), requestUri.getAuthority(), ex.getHttpContext().getPath() + lastPartOfPath, uri.getQuery(), uri.getFragment()).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void copyRequestHeaders(HttpExchange from, HttpURLConnection to) {
        Set<String> requestHopByHopHeaders = this.getHopByHopHeaders((List<String>)from.getRequestHeaders().get("Connection"));
        for (Map.Entry<String, List<String>> me : from.getRequestHeaders().entrySet()) {
            if (requestHopByHopHeaders.contains(me.getKey())) continue;
            for (String value : me.getValue()) {
                to.addRequestProperty(me.getKey(), value);
            }
        }
    }

    private void copyResponseHeaders(HttpURLConnection from, HttpExchange to) {
        Set<String> responseHopByHopHeaders = this.getHopByHopHeaders(from.getHeaderFields().get("Connection"));
        int i = 0;
        while (true) {
            String key = from.getHeaderFieldKey(i);
            String value = from.getHeaderField(i);
            if (value == null) break;
            if (key != null && !responseHopByHopHeaders.contains(key)) {
                if ("Location".equalsIgnoreCase(key) || "Content-Location".equalsIgnoreCase(key) || "URI".equalsIgnoreCase(key)) {
                    value = this.computeReverseProxyDestination(to, value);
                }
                to.getResponseHeaders().add(key, value);
            }
            ++i;
        }
    }

    private String getClientIp(HttpExchange ex) {
        InetSocketAddress clientAddr = ex.getRemoteAddress();
        if (clientAddr.isUnresolved()) {
            log.log(Level.WARNING, "Could not determine client's IP");
            return "unknown";
        }
        return clientAddr.getAddress().getHostAddress();
    }

    private Set<String> getHopByHopHeaders(List<String> connectionValues) {
        List<String> rawConnectionHeaders = HttpExchanges.splitHeaderValues(connectionValues);
        if (rawConnectionHeaders == null) {
            rawConnectionHeaders = Collections.emptyList();
        }
        TreeSet<String> connectionHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        connectionHeaders.addAll(rawConnectionHeaders);
        connectionHeaders.addAll(PREDEFINED_HOP_BY_HOP_HEADERS);
        return connectionHeaders;
    }
}

