/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.Transformer;
import com.sun.net.httpserver.HttpHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Route {
    static final Pattern PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE = Pattern.compile("\\{(.*?)(:\\s(.*?))?\\}");
    static final String VARIABLE_ROUTES_DEFAULT_REGEX = "([^/]*)";
    private final String method;
    private final String uri;
    private final HttpHandler handler;
    private final List<String> parameters;
    private final Pattern regex;
    private final Optional<Transformer> transformer;

    public Route(String method, String uri, HttpHandler handler, Optional<Transformer> transformer) {
        this.method = method;
        this.uri = uri;
        this.handler = handler;
        this.parameters = Route.parseNamedParameters(uri);
        this.regex = Pattern.compile(Route.convertRawUriToRegex(uri));
        this.transformer = transformer;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public Optional<Transformer> getTransformer() {
        return this.transformer;
    }

    public boolean matches(String method, String uri) {
        if (this.method.equalsIgnoreCase(method)) {
            Matcher matcher = this.regex.matcher(uri);
            return matcher.matches();
        }
        return false;
    }

    public Map<String, String> getPathParametersEncoded(String uri) {
        Matcher m;
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.parameters != null && (m = this.regex.matcher(uri)).matches()) {
            Iterator<String> it = this.parameters.iterator();
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                String parameterName = it.next();
                map.put(parameterName, m.group(i));
            }
        }
        return map;
    }

    protected static String convertRawUriToRegex(String rawUri) {
        Matcher groupMatcher = Pattern.compile("\\(([^?].*)\\)").matcher(rawUri);
        String converted = groupMatcher.replaceAll("\\(?:$1\\)");
        Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(converted);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String namedVariablePartOfRoute = matcher.group(3);
            String namedVariablePartOfORouteReplacedWithRegex = namedVariablePartOfRoute != null ? "(" + Matcher.quoteReplacement(namedVariablePartOfRoute) + ")" : VARIABLE_ROUTES_DEFAULT_REGEX;
            matcher.appendReplacement(stringBuffer, namedVariablePartOfORouteReplacedWithRegex);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected static List<String> parseNamedParameters(String path) {
        ArrayList<String> params = null;
        Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(path);
        while (matcher.find()) {
            if (params == null) {
                params = new ArrayList<String>();
            }
            params.add(matcher.group(1));
        }
        return params;
    }
}

