/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.Handler;
import com.github.xgp.http.server.HttpExchanges;
import com.github.xgp.http.server.InternalHttpExchange;
import com.github.xgp.http.server.Route;
import com.github.xgp.http.server.Transformer;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Router
implements HttpHandler {
    private final List<Route> routes = new ArrayList<Route>();
    private final Map<String, Transformer> transformers = new HashMap<String, Transformer>();

    public List<Route> getRoutes() {
        return this.routes;
    }

    public Map<String, Transformer> getTransformers() {
        return this.transformers;
    }

    public Router addTransformer(Transformer transformer) {
        this.transformers.put(transformer.contentType(), transformer);
        return this;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Optional<Route> route = this.getRouteFor(exchange.getRequestMethod(), exchange.getRequestURI());
        if (route.isPresent()) {
            try {
                route.get().getHandler().handle(new InternalHttpExchange(exchange, route.get(), this.transformers));
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpExchanges.cannedRespond(exchange, 500, "500 Internal Server Error: " + e.getMessage());
            }
        } else {
            HttpExchanges.cannedRespond(exchange, 404, "404 Not Found: " + exchange.getRequestURI());
        }
    }

    private Optional<Route> getRouteFor(String method, URI uri) {
        for (Route route : this.routes) {
            if (!route.matches(method, uri.getPath())) continue;
            return Optional.of(route);
        }
        return Optional.empty();
    }

    public Router addHandler(String method, String path, HttpHandler handler) {
        return this.addHandler(method, path, handler, null);
    }

    public Router addHandler(String method, String path, HttpHandler handler, Transformer transformer) {
        this.getRoutes().add(new Route(method, path, handler, Optional.ofNullable(transformer)));
        return this;
    }

    public Router HEAD(String path, Handler handler) {
        return this.addHandler("HEAD", path, handler);
    }

    public Router OPTIONS(String path, Handler handler) {
        return this.addHandler("OPTIONS", path, handler);
    }

    public Router TRACE(String path, Handler handler) {
        return this.addHandler("TRACE", path, handler);
    }

    public Router GET(String path, Handler handler) {
        return this.addHandler("GET", path, handler);
    }

    public Router GET(String path, Handler handler, Transformer transformer) {
        return this.addHandler("GET", path, handler, transformer);
    }

    public Router POST(String path, Handler handler) {
        return this.addHandler("POST", path, handler);
    }

    public Router POST(String path, Handler handler, Transformer transformer) {
        return this.addHandler("POST", path, handler, transformer);
    }

    public Router PUT(String path, Handler handler) {
        return this.addHandler("PUT", path, handler);
    }

    public Router PUT(String path, Handler handler, Transformer transformer) {
        return this.addHandler("PUT", path, handler, transformer);
    }

    public Router DELETE(String path, Handler handler) {
        return this.addHandler("DELETE", path, handler);
    }

    public Router DELETE(String path, Handler handler, Transformer transformer) {
        return this.addHandler("DELETE", path, handler, transformer);
    }

    public Router PATCH(String path, Handler handler) {
        return this.addHandler("PATCH", path, handler);
    }

    public Router PATCH(String path, Handler handler, Transformer transformer) {
        return this.addHandler("PATCH", path, handler, transformer);
    }
}

