/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.http.server;

import com.github.xgp.http.server.Router;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;

public class Server {
    private final int port;
    private final AtomicBoolean started;
    private final HttpServer server;
    private final Router router;

    public Server(int port) {
        this(new Router(), port);
    }

    public Server(Router router, int port) {
        this.port = port;
        this.router = router;
        this.started = new AtomicBoolean(false);
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.server.createContext("/", this.router);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to start HTTP server on port " + port, e);
        }
    }

    public HttpContext createContext(String path) {
        if (!this.started.get()) {
            return this.server.createContext(path);
        }
        throw new IllegalStateException("Cannot create context after server is started");
    }

    public HttpServer httpServer() {
        return this.server;
    }

    public Router router() {
        return this.router;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() throws Exception {
        if (this.started.get()) {
            throw new IllegalStateException("Server is already started");
        }
        this.server.start();
        this.started.set(true);
    }

    public void stop() {
        if (this.started.get()) {
            this.server.stop(0);
            this.started.set(false);
        }
    }
}

