/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Streams {
    private Streams() {
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        out.flush();
    }

    public static byte[] readInputStreamToByteArray(InputStream instream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Streams.copyStream(instream, os);
        return os.toByteArray();
    }

    public static String readInputStreamToString(InputStream instream, Charset charset) throws IOException {
        return new String(Streams.readInputStreamToByteArray(instream), charset);
    }

    public static File writeToTempFile(InputStream in) throws IOException {
        File tmpFile = File.createTempFile("adaptorlib", ".tmp");
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            Streams.copyStream(in, os);
        }
        catch (IOException ex) {
            tmpFile.delete();
            throw ex;
        }
        return tmpFile;
    }

    public static File writeToTempFile(String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        return Streams.writeToTempFile(new ByteArrayInputStream(bytes));
    }

    public static int readFully(InputStream is, byte[] bytes, int off, int len) throws IOException {
        int bytesRead = 0;
        int result = 0;
        if (len == 0) {
            return 0;
        }
        while (result != -1 && bytesRead < len) {
            result = is.read(bytes, off + bytesRead, len - bytesRead);
            if (result == -1) continue;
            bytesRead += result;
        }
        if (bytesRead == 0) {
            return -1;
        }
        return bytesRead;
    }
}

