/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TemporaryFile
implements Closeable {
    private final Path path;

    public TemporaryFile(Path path) {
        this.path = path;
    }

    @Override
    public void close() throws IOException {
        Files.deleteIfExists(this.path);
    }

    public Path path() {
        return this.path;
    }

    public String toString() {
        return String.format("TemporaryFile: %s", this.path);
    }

    public static TemporaryFile file() throws IOException {
        return new TemporaryFile(Files.createTempFile(null, null, new FileAttribute[0]));
    }

    public static TemporaryFile empty() throws IOException {
        Path file = Files.createTempFile(null, null, new FileAttribute[0]);
        Files.delete(file);
        return new TemporaryFile(file);
    }
}

