/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import com.github.xgp.util.BackOff;
import com.github.xgp.util.Reactor;
import java.util.concurrent.TimeUnit;

public class BackoffFailureHandler<T>
implements Reactor.FailureHandler<T> {
    private final BackOff backOff;

    public BackoffFailureHandler(BackOff backOff) {
        this.backOff = backOff;
    }

    protected boolean canRetry(Throwable t, T e) {
        return true;
    }

    @Override
    public void onFailure(Throwable t, Reactor r, T e) {
        if (!this.canRetry(t, e)) {
            return;
        }
        long backOffTime = this.backOff.nextBackOffMillis();
        if (backOffTime == -1L) {
            return;
        }
        r.schedule(e, backOffTime, TimeUnit.MILLISECONDS, this);
    }
}

