/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import com.github.xgp.util.LogFactory;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;

public class Log {
    private final String category;
    private static final PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
    private static final PrintWriter err = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.err)));
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        }
    };
    public static final String LOG_LEVEL_PROPERTY = "log.level";
    public static final String LOG_BOOTSTRAP_CATEGORY = "log.bootstrap";
    private static final LogFactory logFactory;

    public static Log get(String category) {
        return logFactory.get(category);
    }

    public static Log get(Class clazz) {
        return logFactory.get(clazz);
    }

    private Log(String category) {
        this.category = category;
    }

    public void debug(String msg, Object ... args) {
        Log._debug(this.category, msg, args);
    }

    public void info(String msg, Object ... args) {
        Log._info(this.category, msg, args);
    }

    public void error(String msg, Object ... args) {
        Log._error(this.category, null, msg, args);
    }

    public void error(Throwable throwable, String msg, Object ... args) {
        Log._error(this.category, throwable, msg, args);
    }

    public static void _err(String msg) {
        err.println(msg);
    }

    public static void _out(String msg) {
        out.println(msg);
    }

    public static void _debug(String category, String msg, Object ... args) {
        Log._log(category, Level.DEBUG, null, msg, args);
    }

    public static void _info(String category, String msg, Object ... args) {
        Log._log(category, Level.INFO, null, msg, args);
    }

    public static void _error(String category, String msg, Object ... args) {
        Log._log(category, Level.ERROR, null, msg, args);
    }

    public static void _error(String category, Throwable throwable, String msg, Object ... args) {
        Log._log(category, Level.ERROR, throwable, msg, args);
    }

    public static void _log(String category, Level level, Throwable throwable, String msg, Object ... args) {
        if (level.ordinal() >= Log.systemLevel().ordinal()) {
            Log._err(String.format("%s [%s] %s: %s", level.abbr(), dateFormat.get().format(new Date()), category, String.format(msg, args)));
            if (throwable != null) {
                throwable.printStackTrace(err);
            }
        }
    }

    private static Level levelForName(String name) {
        try {
            return Level.valueOf(name);
        }
        catch (Exception exception) {
            return Level.DEBUG;
        }
    }

    private static Level systemLevel() {
        return Log.levelForName(System.getProperty(LOG_LEVEL_PROPERTY, "DEBUG"));
    }

    private static List<LogFactory> findServiceProviders() {
        ServiceLoader<LogFactory> serviceLoader = ServiceLoader.load(LogFactory.class);
        ArrayList<LogFactory> providerList = new ArrayList<LogFactory>();
        for (LogFactory provider : serviceLoader) {
            providerList.add(provider);
        }
        return providerList;
    }

    public static void main(String[] argv) throws Exception {
        Log log = Log.get(Log.class);
        log.debug("Debug", new Object[0]);
        log.debug("Debug %s", "something");
        log.info("Info", new Object[0]);
        log.info("Info %s", "something");
        log.error("Error", new Object[0]);
        log.error("Error %s", "something");
        log.error(new RuntimeException(), "Error %s", "error");
        System.exit(0);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                out.flush();
                out.close();
                err.flush();
                err.close();
            }
        });
        List<LogFactory> providerList = Log.findServiceProviders();
        if (providerList.size() == 0) {
            Log._error(LOG_BOOTSTRAP_CATEGORY, "No LogFactory present. Using stderr at %s level.", new Object[]{Log.systemLevel()});
            logFactory = new LogFactory(){

                @Override
                public Log get(String category) {
                    return new Log(category);
                }

                @Override
                public Log get(Class clazz) {
                    return new Log(clazz.getSimpleName());
                }
            };
        } else {
            if (providerList.size() > 1) {
                Log._error(LOG_BOOTSTRAP_CATEGORY, "More than one LogFactory (%d) present. Using %s.", providerList.size(), providerList.get(0));
            }
            logFactory = providerList.get(0);
        }
    }

    static enum Level {
        DEBUG("DEB"),
        INFO("INF"),
        ERROR("ERR");

        private final String abbr;

        private Level(String abbr) {
            this.abbr = abbr;
        }

        public String abbr() {
            return this.abbr;
        }
    }
}

