/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import com.github.xgp.util.Log;
import java.util.ArrayList;
import java.util.List;

public interface Loggable {
    default public Logger log(String format, Object ... args) {
        return new Logger(this.getClass(), format, args);
    }

    default public Logger log(String format) {
        return new Logger(this.getClass(), format, new Object[0]);
    }

    public static class Logger {
        private final Class clazz;
        private final String format;
        private final List<Object> args;
        private Throwable throwable;

        private Logger(Class clazz, String format, Object ... args) {
            this.clazz = clazz;
            this.format = format;
            this.args = new ArrayList<Object>();
            this.args(args);
        }

        public void args(Object ... args) {
            for (Object arg : args) {
                this.arg(arg);
            }
        }

        public void arg(Object arg) {
            this.args.add(arg);
        }

        public void ex(Throwable throwable) {
            this.throwable = throwable;
        }

        public void debug() {
            Log.get(this.clazz).debug(this.format, this.args);
        }

        public void info() {
            Log.get(this.clazz).info(this.format, this.args);
        }

        public void error() {
            Log.get(this.clazz).error(this.throwable, this.format, this.args);
        }
    }
}

