/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface Reactor<T> {
    public void schedule(T var1);

    public void schedule(T var1, FailureHandler<T> var2);

    default public void schedule(T e, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("Delayed scheduling is not supported by this Reactor");
    }

    default public void schedule(T e, long delay, TimeUnit unit, FailureHandler<T> handler) {
        throw new UnsupportedOperationException("Delayed scheduling is not supported by this Reactor");
    }

    public void stop();

    public Set<T> getProcessing();

    public static class Task<T> {
        private final T task;
        private final FailureHandler<T> handler;

        public Task(T task, FailureHandler<T> handler) {
            this.task = task;
            this.handler = handler;
        }

        public T getTask() {
            return this.task;
        }

        public FailureHandler<T> getHandler() {
            return this.handler;
        }
    }

    public static interface FailureHandler<T> {
        public static final FailureHandler DO_NOTHING = new FailureHandler(){

            public void onFailure(Throwable t, Reactor r, Object e) {
            }
        };

        public void onFailure(Throwable var1, Reactor var2, T var3);
    }
}

