/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import java.util.ArrayList;
import java.util.List;

public class Tree<T> {
    private final T data;
    private final Tree<T> parent;
    private final List<Tree<T>> children;

    public Tree(T data) {
        this(data, null);
    }

    public Tree(T data, Tree<T> parent) {
        this.data = data;
        this.parent = parent;
        this.children = new ArrayList<Tree<T>>();
    }

    public T getData() {
        return this.data;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public Tree<T> addChild(T data) {
        Tree<T> child = new Tree<T>(data, this);
        this.children.add(child);
        return child;
    }

    public List<T> flatten() {
        return this.flatten(new ArrayList(), this);
    }

    private List<T> flatten(List<T> list, Tree<T> item) {
        list.add(item.getData());
        for (Tree<T> child : item.getChildren()) {
            this.flatten(list, child);
        }
        return list;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.data).append(" (root=").append(this.isRoot()).append(")\n");
        this.toString(s, this.getChildren(), 2);
        return s.toString();
    }

    private void toString(StringBuilder s, List<Tree<T>> children, int indent) {
        for (Tree<T> child : children) {
            for (int i = 0; i < indent; ++i) {
                s.append(' ');
            }
            s.append(child.getData()).append("\n");
            this.toString(s, child.getChildren(), indent + indent);
        }
    }
}

