/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.util;

import com.github.xgp.util.Managed;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class WorkQueue<T>
implements Managed,
Runnable {
    protected final BlockingQueue<T> queue;
    protected final Function<T, ? extends Object> function;
    protected final Semaphore available;
    protected final ExecutorService executor;
    protected final Set<T> processing;
    protected final long delay;
    protected final int permits;
    protected final Thread thread;
    private volatile boolean running = false;

    public WorkQueue(Function<T, ? extends Object> function) {
        this(new LinkedBlockingQueue(), function, Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1000L);
    }

    public WorkQueue(BlockingQueue<T> queue, Function<T, ? extends Object> function, int permits, int threads, long delay) {
        if (permits > threads) {
            throw new IllegalStateException("permits must be <= threads");
        }
        this.permits = permits;
        this.delay = delay;
        this.queue = queue;
        this.function = function;
        this.available = new Semaphore(permits, true);
        this.executor = Executors.newFixedThreadPool(threads);
        this.processing = Collections.newSetFromMap(new WeakHashMap());
        this.thread = new Thread(this);
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public Function<T, ? extends Object> getFunction() {
        return this.function;
    }

    public Set<T> getProcessing() {
        return this.processing;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() throws Exception {
        try {
            this.thread.start();
            Managed.addShutdownHook(this);
        }
        catch (IllegalThreadStateException e) {
            throw new Exception(e);
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.executor.shutdown();
    }

    @Override
    public void await() {
        try {
            this.executor.awaitTermination(this.delay * (long)this.permits, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.isRunning() && !Thread.currentThread().isInterrupted()) {
            try {
                if (!this.available.tryAcquire(this.delay, TimeUnit.MILLISECONDS)) continue;
                try {
                    final T item = this.queue.poll(this.delay, TimeUnit.MILLISECONDS);
                    if (item == null) {
                        this.available.release();
                        continue;
                    }
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WorkQueue.this.processing.add(item);
                                WorkQueue.this.function.apply(item);
                            }
                            finally {
                                WorkQueue.this.processing.remove(item);
                                WorkQueue.this.available.release();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.available.release();
                    Thread.sleep(this.delay);
                }
            }
            catch (InterruptedException e) {
                this.stop();
            }
        }
    }
}

