/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.xml.slurpersupport;

import com.github.xgp.xml.slurpersupport.Attributes;
import com.github.xgp.xml.slurpersupport.NoChildren;
import com.github.xgp.xml.slurpersupport.Node;
import com.github.xgp.xml.slurpersupport.NodeChild;
import com.github.xgp.xml.slurpersupport.NodeChildren;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class GPathResult {
    protected final GPathResult parent;
    protected final String name;
    protected final String namespacePrefix;
    protected final Map namespaceMap = new HashMap();
    protected final Map<String, String> namespaceTagHints;

    public GPathResult(GPathResult parent, String name, String namespacePrefix, Map<String, String> namespaceTagHints) {
        if (parent == null) {
            this.parent = this;
            this.namespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        } else {
            this.parent = parent;
            this.namespaceMap.putAll(parent.namespaceMap);
        }
        this.name = name;
        this.namespacePrefix = namespacePrefix;
        this.namespaceTagHints = namespaceTagHints;
    }

    public GPathResult a(String property) {
        if (property.indexOf(":") != -1) {
            int i = property.indexOf(":");
            return new Attributes(this, "@" + property.substring(i + 1), property.substring(1, i), this.namespaceTagHints);
        }
        return new Attributes(this, "@" + property, this.namespaceTagHints);
    }

    public GPathResult e(String property) {
        if (property.indexOf(":") != -1) {
            int i = property.indexOf(":");
            return new NodeChildren(this, property.substring(i + 1), property.substring(0, i), this.namespaceTagHints);
        }
        return new NodeChildren(this, property, this.namespaceTagHints);
    }

    public Object getProperty(String property) {
        if ("..".equals(property)) {
            return this.parent();
        }
        if ("*".equals(property)) {
            return this.children();
        }
        if ("**".equals(property)) {
            return this.depthFirst();
        }
        if (property.startsWith("@")) {
            if (property.indexOf(":") != -1) {
                int i = property.indexOf(":");
                return new Attributes(this, "@" + property.substring(i + 1), property.substring(1, i), this.namespaceTagHints);
            }
            return new Attributes(this, property, this.namespaceTagHints);
        }
        if (property.indexOf(":") != -1) {
            int i = property.indexOf(":");
            return new NodeChildren(this, property.substring(i + 1), property.substring(0, i), this.namespaceTagHints);
        }
        return new NodeChildren(this, property, this.namespaceTagHints);
    }

    public String name() {
        return this.name;
    }

    public GPathResult parent() {
        return this.parent;
    }

    public GPathResult children() {
        return new NodeChildren(this, this.namespaceTagHints);
    }

    public String lookupNamespace(String prefix) {
        return this.namespaceTagHints.get(prefix);
    }

    public String toString() {
        return this.text();
    }

    public Integer toInteger() {
        return Integer.valueOf(this.text());
    }

    public Long toLong() {
        return Long.valueOf(this.text());
    }

    public Float toFloat() {
        return Float.valueOf(this.text());
    }

    public Double toDouble() {
        return Double.valueOf(this.text());
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.text());
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.text());
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.text());
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.text());
    }

    public Boolean toBoolean() {
        return Boolean.valueOf(this.text());
    }

    public GPathResult declareNamespace(Map newNamespaceMapping) {
        this.namespaceMap.putAll(newNamespaceMapping);
        return this;
    }

    public boolean equals(Object obj) {
        return this.text().equals(obj.toString());
    }

    public Object getAt(int index) {
        if (index < 0) {
            List list = this.list();
            int adjustedIndex = index + list.size();
            if (adjustedIndex >= 0 && adjustedIndex < list.size()) {
                return list.get(adjustedIndex);
            }
        } else {
            Iterator<GPathResult> iter = this.iterator();
            int count = 0;
            while (iter.hasNext()) {
                if (count++ == index) {
                    return iter.next();
                }
                iter.next();
            }
        }
        return new NoChildren(this, this.name, this.namespaceTagHints);
    }

    public Iterator<GPathResult> depthFirst() {
        return new Iterator<GPathResult>(){
            private final List list = new LinkedList();
            private final Stack stack = new Stack();
            private Iterator iter = GPathResult.this.iterator();
            private GPathResult next = this.getNextByDepth();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public GPathResult next() {
                try {
                    GPathResult gPathResult = this.next;
                    return gPathResult;
                }
                finally {
                    this.next = this.getNextByDepth();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private GPathResult getNextByDepth() {
                while (this.iter.hasNext()) {
                    GPathResult node = (GPathResult)this.iter.next();
                    this.list.add(node);
                    this.stack.push(this.iter);
                    this.iter = node.children().iterator();
                }
                if (this.list.isEmpty()) {
                    return null;
                }
                GPathResult result = (GPathResult)this.list.get(0);
                this.list.remove(0);
                this.iter = (Iterator)this.stack.pop();
                return result;
            }
        };
    }

    public Iterator breadthFirst() {
        return new Iterator(){
            private final List list = new LinkedList();
            private Iterator iter = GPathResult.this.iterator();
            private GPathResult next = this.getNextByBreadth();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                try {
                    GPathResult gPathResult = this.next;
                    return gPathResult;
                }
                finally {
                    this.next = this.getNextByBreadth();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private GPathResult getNextByBreadth() {
                ArrayList<GPathResult> children = new ArrayList<GPathResult>();
                while (this.iter.hasNext() || !children.isEmpty()) {
                    if (this.iter.hasNext()) {
                        GPathResult node = (GPathResult)this.iter.next();
                        this.list.add(node);
                        this.list.add(this.iter);
                        children.add(node.children());
                        continue;
                    }
                    ArrayList<GPathResult> nextLevel = new ArrayList<GPathResult>();
                    for (Object e : children) {
                        GPathResult next = (GPathResult)e;
                        Iterator<GPathResult> iterator = next.iterator();
                        while (iterator.hasNext()) {
                            nextLevel.add(iterator.next());
                        }
                    }
                    this.iter = nextLevel.iterator();
                    children = new ArrayList();
                }
                if (this.list.isEmpty()) {
                    return null;
                }
                GPathResult result = (GPathResult)this.list.get(0);
                this.list.remove(0);
                this.iter = (Iterator)this.list.get(0);
                this.list.remove(0);
                return result;
            }
        };
    }

    public List list() {
        Iterator<GPathResult> iter = this.nodeIterator();
        LinkedList<NodeChild> result = new LinkedList<NodeChild>();
        while (iter.hasNext()) {
            result.add(new NodeChild((Node)((Object)iter.next()), this.parent, this.namespacePrefix, this.namespaceTagHints));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract String text();

    public abstract GPathResult parents();

    public abstract Iterator<GPathResult> childNodes();

    public abstract Iterator<GPathResult> iterator();

    public abstract Iterator<GPathResult> nodeIterator();
}

