/*
 * Decompiled with CFR 0.152.
 */
package com.github.xgp.xml.slurpersupport;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Node {
    private final String name;
    private final Map attributes;
    private final Map attributeNamespaces;
    private final String namespaceURI;
    private final List children = new LinkedList();

    public Node(Node parent, String name, Map attributes, Map attributeNamespaces, String namespaceURI) {
        this.name = name;
        this.attributes = attributes;
        this.attributeNamespaces = attributeNamespaces;
        this.namespaceURI = namespaceURI;
    }

    public String name() {
        return this.name;
    }

    public String namespaceURI() {
        return this.namespaceURI;
    }

    public Map attributes() {
        return this.attributes;
    }

    public List children() {
        return this.children;
    }

    public void addChild(Object child) {
        this.children.add(child);
    }

    public String text() {
        StringBuffer buff = new StringBuffer();
        for (Object child : this.children) {
            if (child instanceof Node) {
                buff.append(((Node)child).text());
                continue;
            }
            buff.append(child);
        }
        return buff.toString();
    }

    public Iterator childNodes() {
        return new Iterator(){
            private final Iterator iter;
            private Object nextElementNodes;
            {
                this.iter = Node.this.children.iterator();
                this.nextElementNodes = this.getNextElementNodes();
            }

            @Override
            public boolean hasNext() {
                return this.nextElementNodes != null;
            }

            public Object next() {
                try {
                    Object object = this.nextElementNodes;
                    return object;
                }
                finally {
                    this.nextElementNodes = this.getNextElementNodes();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Object getNextElementNodes() {
                while (this.iter.hasNext()) {
                    Object node = this.iter.next();
                    if (!(node instanceof Node)) continue;
                    return node;
                }
                return null;
            }
        };
    }
}

