/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.config;

import java.util.Map;

public interface Configurable {
    public void setConfig(Map<String, Object> var1);

    default public String getOr(Map<String, Object> config, String key, String defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object o = config.get(key);
        if (o != null) {
            return o.toString();
        }
        return defaultValue;
    }

    default public boolean getBooleanOr(Map<String, Object> config, String key, boolean defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object o = config.get(key);
        if (o != null) {
            if (o instanceof String) {
                return Boolean.parseBoolean((String)o);
            }
            return (Boolean)o;
        }
        return defaultValue;
    }

    default public int getIntOr(Map<String, Object> config, String key, int defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object o = config.get(key);
        if (o != null) {
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
            return (Integer)o;
        }
        return defaultValue;
    }

    default public double getDoubleOr(Map<String, Object> config, String key, double defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        Object o = config.get(key);
        if (o != null) {
            if (o instanceof String) {
                return Double.parseDouble((String)o);
            }
            return (Double)o;
        }
        return defaultValue;
    }
}

