/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.phasetwo.keycloak.config.RealmAttributesConfigLoader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public interface ConfigurationAware {
    public String getId();

    default public List<Map<String, Object>> getConfigurations(KeycloakSession session) {
        RealmModel realm = ConfigurationAware.getRealm(session);
        if (realm == null) {
            return ImmutableList.of();
        }
        return RealmAttributesConfigLoader.loadConfigurations(session, realm.getName(), this.getId()).stream().map(config -> RealmAttributesConfigLoader.safeConvertToMap(config)).collect(Collectors.toList());
    }

    public static RealmModel getRealm(KeycloakSession session) {
        if (session.getContext() == null) {
            return null;
        }
        if (session.getContext().getRealm() != null) {
            return session.getContext().getRealm();
        }
        if (session.getContext().getAuthenticationSession() != null && session.getContext().getAuthenticationSession().getRealm() != null) {
            return session.getContext().getAuthenticationSession().getRealm();
        }
        if (session.getContext().getClient() != null && session.getContext().getClient().getRealm() != null) {
            return session.getContext().getClient().getRealm();
        }
        return null;
    }

    default public Map<String, Object> getConfiguration(KeycloakSession session) {
        List<Map<String, Object>> configs = this.getConfigurations(session);
        if (configs == null || configs.size() == 0) {
            return ImmutableMap.of();
        }
        return configs.get(0);
    }

    default public String configToString(Map<String, Object> config) {
        if (config == null) {
            return "[empty]";
        }
        return "[" + Joiner.on((String)",").withKeyValueSeparator("=").join(config) + "]";
    }
}

