/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.config;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.util.JsonSerialization;

public class RealmAttributesConfigLoader {
    private static final Logger log = Logger.getLogger(RealmAttributesConfigLoader.class);
    public static final String REALM_ATTRIBUTE_CONFIG_PREFIX = "_providerConfig";

    public static <T> Optional<T> loadConfiguration(KeycloakSession session, String realm, String providerId, Class<T> clazz) {
        return RealmAttributesConfigLoader.loadConfiguration(session, realm, providerId).map(s -> RealmAttributesConfigLoader.safeConvert(s, clazz));
    }

    public static Optional<String> loadConfiguration(KeycloakSession session, String realm, String providerId) {
        RealmModel r = session.realms().getRealmByName(realm);
        if (r == null) {
            return Optional.empty();
        }
        return Optional.of(r.getAttribute(RealmAttributesConfigLoader.getKey(providerId)));
    }

    public static <T> List<T> loadConfigurations(KeycloakSession session, String realm, String providerId, Class<T> clazz) {
        return RealmAttributesConfigLoader.loadConfigurations(session, realm, providerId).stream().map(s -> RealmAttributesConfigLoader.safeConvert(s, clazz)).collect(Collectors.toList());
    }

    public static List<String> loadConfigurations(KeycloakSession session, String realm, String providerId) {
        log.debugf("loading configurations for realm=%s, provider=%s. using query %s", (Object)realm, (Object)providerId, (Object)RealmAttributesConfigLoader.getKey(providerId));
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        TypedQuery query = em.createQuery("SELECT ra FROM RealmAttributeEntity ra WHERE ra.realm.name = :realm AND ra.name LIKE :name ORDER BY ra.name", RealmAttributeEntity.class);
        query.setParameter("name", (Object)("" + RealmAttributesConfigLoader.getKey(providerId) + "%"));
        query.setParameter("realm", (Object)realm);
        return query.getResultStream().filter(e -> realm.equals(e.getRealm().getName())).map(RealmAttributeEntity::getValue).collect(Collectors.toList());
    }

    private static String getKey(String providerId) {
        return String.format("%s.%s", REALM_ATTRIBUTE_CONFIG_PREFIX, providerId);
    }

    private static <T> T safeConvert(String s, Class<T> clazz) {
        try {
            return (T)JsonSerialization.readValue((String)s, clazz);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return null;
        }
    }

    public static Map<String, Object> safeConvertToMap(String s) {
        try {
            return (Map)JsonSerialization.readValue((String)s, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            log.warn((Object)e);
            return null;
        }
    }
}

