/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import com.github.xgp.util.BackOff;
import com.github.xgp.util.ExponentialBackOff;
import io.phasetwo.keycloak.events.SenderEventListenerProvider;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.keycloak.util.JsonSerialization;

public class HttpSenderEventListenerProvider
extends SenderEventListenerProvider {
    private static final Logger log = Logger.getLogger(HttpSenderEventListenerProvider.class);
    protected static final String TARGET_URI = "targetUri";
    protected static final String RETRY = "retry";
    protected static final String SHARED_SECRET = "sharedSecret";
    protected static final String HMAC_ALGORITHM = "hmacAlgorithm";
    protected static final String BACKOFF_INITIAL_INTERVAL = "backoffInitialInterval";
    protected static final String BACKOFF_MAX_ELAPSED_TIME = "backoffMaxElapsedTime";
    protected static final String BACKOFF_MAX_INTERVAL = "backoffMaxInterval";
    protected static final String BACKOFF_MULTIPLIER = "backoffMultiplier";
    protected static final String BACKOFF_RANDOMIZATION_FACTOR = "backoffRandomizationFactor";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    public HttpSenderEventListenerProvider(KeycloakSession session, ScheduledExecutorService exec) {
        super(session, exec);
    }

    @Override
    BackOff getBackOff() {
        boolean retry = this.getBooleanOr(this.config, RETRY, true);
        log.debugf("Retry is %b %s", (Object)retry, (Object)this.getOr(this.config, RETRY, "[empty]"));
        if (!retry) {
            return BackOff.STOP_BACKOFF;
        }
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(this.getIntOr(this.config, BACKOFF_INITIAL_INTERVAL, 500)).setMaxElapsedTimeMillis(this.getIntOr(this.config, BACKOFF_MAX_ELAPSED_TIME, 900000)).setMaxIntervalMillis(this.getIntOr(this.config, BACKOFF_MAX_INTERVAL, 60000)).setMultiplier(this.getDoubleOr(this.config, BACKOFF_MULTIPLIER, 1.5)).setRandomizationFactor(this.getDoubleOr(this.config, BACKOFF_RANDOMIZATION_FACTOR, 0.5)).build();
    }

    String getTargetUri() {
        return this.config.get(TARGET_URI).toString();
    }

    Optional<String> getSharedSecret() {
        return Optional.ofNullable(this.config.get(SHARED_SECRET)).map(Object::toString);
    }

    Optional<String> getHmacAlgorithm() {
        return Optional.ofNullable(this.config.get(HMAC_ALGORITHM)).map(Object::toString);
    }

    @Override
    void send(SenderEventListenerProvider.SenderTask task) throws SenderEventListenerProvider.SenderException, IOException {
        this.send(task, this.getTargetUri(), this.getSharedSecret(), this.getHmacAlgorithm());
    }

    protected void send(SenderEventListenerProvider.SenderTask task, String targetUri, Optional<String> sharedSecret, Optional<String> algorithm) throws SenderEventListenerProvider.SenderException, IOException {
        log.debugf("attempting send to %s", (Object)targetUri);
        try {
            SimpleHttp request = SimpleHttp.doPost((String)targetUri, (KeycloakSession)this.session).json(task.getEvent());
            sharedSecret.ifPresent(secret -> request.header("X-Keycloak-Signature", this.hmacFor(task.getEvent(), (String)secret, algorithm.orElse(HMAC_SHA256_ALGORITHM))));
            SimpleHttp.Response response = request.asResponse();
            int status = response.getStatus();
            log.debugf("sent to %s (%d)", (Object)targetUri, (Object)status);
            if (status < 200 || status >= 300) {
                log.warnf("Sending failure (Server response:%d)", (Object)status);
                throw new SenderEventListenerProvider.SenderException(this, true);
            }
        }
        catch (SenderEventListenerProvider.SenderException se) {
            throw se;
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Sending exception to %s", (Object)targetUri);
            throw new SenderEventListenerProvider.SenderException(this, false, e);
        }
    }

    protected String hmacFor(Object o, String sharedSecret, String algorithm) {
        try {
            String data = JsonSerialization.writeValueAsString((Object)o);
            return HttpSenderEventListenerProvider.calculateHmacSha(data, sharedSecret, algorithm);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to sign data", (Throwable)e);
            return "";
        }
    }

    public static String calculateHmacSha(String data, String key, String algorithm) throws SignatureException {
        String result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(signingKey);
            byte[] digest = mac.doFinal(data.getBytes());
            StringBuilder sb = new StringBuilder(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(0xFF & b);
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }
}

