/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import com.google.auto.service.AutoService;
import com.google.common.util.concurrent.MoreExecutors;
import io.phasetwo.keycloak.events.HttpSenderEventListenerProvider;
import io.phasetwo.keycloak.events.MultiEventListenerProviderFactory;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;

@AutoService(value={EventListenerProviderFactory.class})
public class HttpSenderEventListenerProviderFactory
extends MultiEventListenerProviderFactory {
    private static final Logger log = Logger.getLogger(HttpSenderEventListenerProviderFactory.class);
    public static final String PROVIDER_ID = "ext-event-http";
    private ScheduledExecutorService exec;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    protected EventListenerProvider configure(KeycloakSession session, Map<String, Object> config) {
        HttpSenderEventListenerProvider provider = new HttpSenderEventListenerProvider(session, this.exec);
        log.infof("Configuring %s with %s", (Object)provider.getClass().getName(), (Object)this.configToString(config));
        provider.setConfig(config);
        return provider;
    }

    @Override
    public void init(Config.Scope scope) {
        this.exec = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors()));
    }

    @Override
    public void close() {
        try {
            log.info((Object)"Shutting down scheduler");
            this.exec.shutdown();
        }
        catch (Exception e) {
            log.warn((Object)"Error in shutdown of scheduler", (Throwable)e);
        }
    }

    @Override
    protected boolean isAsync() {
        return true;
    }
}

