/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import io.phasetwo.keycloak.events.RunnableTransaction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class MultiEventListenerProvider
implements EventListenerProvider {
    private static final Logger log = Logger.getLogger(MultiEventListenerProvider.class);
    private final KeycloakSession session;
    private final List<EventListenerProvider> providers;
    private final boolean async;
    private final ExecutorService exec;
    private RunnableTransaction runnableTrx;

    public MultiEventListenerProvider(KeycloakSession session, List<EventListenerProvider> providers, boolean async, ExecutorService exec) {
        this.session = session;
        this.providers = providers;
        this.async = async;
        this.exec = exec;
        if (async) {
            this.runnableTrx = new RunnableTransaction();
            session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.runnableTrx);
        }
    }

    public void onEvent(Event event) {
        log.debugf("onEvent %s %s", (Object)event.getType(), (Object)event.getId());
        this.providers.forEach(p -> this.run(() -> p.onEvent(event)));
    }

    public void onEvent(AdminEvent adminEvent, boolean b) {
        log.debugf("onEvent %s %s %s", (Object)adminEvent.getOperationType(), (Object)adminEvent.getResourceType(), (Object)adminEvent.getResourcePath());
        this.providers.forEach(p -> this.run(() -> p.onEvent(adminEvent, b)));
    }

    private void run(Runnable task) {
        try {
            if (this.async) {
                this.runnableTrx.addRunnable(task);
            } else {
                task.run();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Problem running EventListenerProvider", (Throwable)e);
        }
    }

    public void close() {
    }
}

