/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import io.phasetwo.keycloak.config.ConfigurationAware;
import io.phasetwo.keycloak.events.AbstractEventListenerProviderFactory;
import io.phasetwo.keycloak.events.MultiEventListenerProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.KeycloakSession;

public abstract class MultiEventListenerProviderFactory
extends AbstractEventListenerProviderFactory
implements ConfigurationAware {
    private static final Logger log = Logger.getLogger(MultiEventListenerProviderFactory.class);

    public MultiEventListenerProvider create(KeycloakSession session) {
        try {
            ExecutorService exec = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("multi-event-provider-threads");
            List<EventListenerProvider> providers = this.getConfigurations(session).stream().map(config -> this.configure(session, (Map<String, Object>)config)).collect(Collectors.toList());
            return new MultiEventListenerProvider(session, providers, this.isAsync(), exec);
        }
        catch (Exception e) {
            log.warn((Object)"Error configuring provider", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected abstract EventListenerProvider configure(KeycloakSession var1, Map<String, Object> var2);

    protected boolean isAsync() {
        return false;
    }
}

