/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;

public class RunnableTransaction
extends AbstractKeycloakTransaction {
    private static final Logger log = Logger.getLogger(RunnableTransaction.class);
    protected final List<Runnable> runnables = new LinkedList<Runnable>();

    public void addRunnable(Runnable r) {
        this.runnables.add(r);
    }

    protected void commitImpl() {
        try {
            this.runnables.forEach(task -> {
                try {
                    task.run();
                }
                catch (Exception e1) {
                    log.warn((Object)"Error running Runnable", (Throwable)e1);
                }
            });
        }
        catch (Exception e2) {
            log.warn((Object)"Error running RunnableTransaction", (Throwable)e2);
        }
    }

    protected void rollbackImpl() {
        this.runnables.clear();
    }
}

