/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import io.phasetwo.keycloak.config.Configurable;
import io.phasetwo.keycloak.events.Events;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptExecutionException;
import org.keycloak.scripting.ScriptingProvider;

public class ScriptEventListenerProvider
implements EventListenerProvider,
Configurable {
    private static final Logger log = Logger.getLogger(ScriptEventListenerProvider.class);
    protected static final String SCRIPTS_DISABLED_ENV = "SCRIPTS_DISABLED";
    protected static final String ON_EVENT_FUNCTION_NAME = "onEvent";
    protected static final String ON_ADMIN_EVENT_FUNCTION_NAME = "onAdminEvent";
    protected static final String SCRIPT_CODE = "scriptCode";
    protected static final String SCRIPT_NAME = "scriptName";
    protected static final String SCRIPT_DESCRIPTION = "scriptDescription";
    protected final KeycloakSession session;
    protected final boolean scriptsDisabled;
    protected Map<String, Object> config;

    public ScriptEventListenerProvider(KeycloakSession session) {
        this.session = session;
        this.scriptsDisabled = Boolean.parseBoolean(System.getenv(SCRIPTS_DISABLED_ENV));
    }

    @Override
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void onEvent(Event event) {
        if (this.scriptsDisabled) {
            return;
        }
        log.debugf("run event in js\n%s", (Object)this.config.get(SCRIPT_CODE).toString());
        InvocableScriptAdapter invocableScriptAdapter = this.getInvocableScriptAdapter(event.getRealmId(), bindings -> {
            bindings.put("event", (Object)event);
            bindings.put("realm", (Object)Events.getRealm(this.session, event));
            bindings.put("user", (Object)Events.getUser(this.session, event));
            bindings.put("session", (Object)this.session);
            bindings.put("LOG", (Object)log);
        });
        this.tryInvoke(invocableScriptAdapter, ON_EVENT_FUNCTION_NAME, event);
    }

    public void onEvent(AdminEvent event, boolean b) {
        if (this.scriptsDisabled) {
            return;
        }
        log.debugf("run admin event in js\n%s", (Object)this.config.get(SCRIPT_CODE).toString());
        InvocableScriptAdapter invocableScriptAdapter = this.getInvocableScriptAdapter(event.getRealmId(), bindings -> {
            bindings.put("event", (Object)event);
            bindings.put("realm", (Object)Events.getRealm(this.session, event));
            bindings.put("authUser", (Object)Events.getAuthUser(this.session, event));
            bindings.put("session", (Object)this.session);
            bindings.put("LOG", (Object)log);
        });
        this.tryInvoke(invocableScriptAdapter, ON_ADMIN_EVENT_FUNCTION_NAME, event, b);
    }

    public void close() {
    }

    private void tryInvoke(InvocableScriptAdapter invocableScriptAdapter, String functionName, Object ... args) {
        if (!invocableScriptAdapter.isDefined(functionName)) {
            log.warnf("%s not defined in %s", (Object)functionName, (Object)this.config.get(SCRIPT_NAME).toString());
            return;
        }
        try {
            log.debugf("Invoking script function %s", (Object)functionName);
            invocableScriptAdapter.invokeFunction(functionName, args);
        }
        catch (ScriptExecutionException e) {
            log.error((Object)"Error in script execution", (Throwable)e);
        }
    }

    private InvocableScriptAdapter getInvocableScriptAdapter(String realmId, ScriptBindingsConfigurer bindings) {
        String scriptName = this.config.get(SCRIPT_NAME).toString();
        String scriptCode = this.config.get(SCRIPT_CODE).toString();
        String scriptDescription = this.config.get(SCRIPT_DESCRIPTION).toString();
        ScriptingProvider scripting = (ScriptingProvider)this.session.getProvider(ScriptingProvider.class);
        ScriptModel script = scripting.createScript(realmId, "text/javascript", scriptName, scriptCode, scriptDescription);
        return scripting.prepareInvocableScript(script, bindings);
    }
}

