/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import com.github.xgp.util.BackOff;
import com.google.common.collect.Maps;
import io.phasetwo.keycloak.config.Configurable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;

public abstract class SenderEventListenerProvider
implements EventListenerProvider,
Configurable {
    private static final Logger log = Logger.getLogger(SenderEventListenerProvider.class);
    protected final KeycloakSession session;
    protected final ScheduledExecutorService exec;
    protected Map<String, Object> config;

    public SenderEventListenerProvider(KeycloakSession session, ScheduledExecutorService exec) {
        this.session = session;
        this.exec = exec;
    }

    @Override
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void onEvent(Event event) {
        this.schedule(new SenderTask(ModelToRepresentation.toRepresentation((Event)event), this.getBackOff()), 0L, TimeUnit.MILLISECONDS);
    }

    public void onEvent(AdminEvent event, boolean b) {
        this.schedule(new SenderTask(ModelToRepresentation.toRepresentation((AdminEvent)event), this.getBackOff()), 0L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        log.debugf("called close() on SenderEventListenerProvider", new Object[0]);
    }

    BackOff getBackOff() {
        return BackOff.STOP_BACKOFF;
    }

    protected void schedule(SenderTask task, long delay, TimeUnit unit) {
        if (this.exec.isShutdown()) {
            log.warn((Object)"Task scheduled after shutdown initiated");
            return;
        }
        try {
            this.exec.schedule(() -> {
                try {
                    this.send(task);
                }
                catch (SenderException | IOException e) {
                    log.debug((Object)"sending exception", (Throwable)e);
                    if (e instanceof SenderException && !((SenderException)e).isRetryable()) {
                        return;
                    }
                    log.debugf("BackOff policy is %s", (Object)(BackOff.STOP_BACKOFF == task.getBackOff() ? "STOP" : "BACKOFF"));
                    long backOffTime = task.getBackOff().nextBackOffMillis();
                    if (backOffTime == -1L) {
                        return;
                    }
                    log.debugf("retrying in %d due to %s", backOffTime, (Object)e.getCause());
                    this.schedule(task, backOffTime, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    log.warn((Object)"Uncaught Sender error", t);
                }
            }, delay, unit);
        }
        catch (Exception e) {
            log.warn((Object)"Error scheduling task", (Throwable)e);
        }
    }

    abstract void send(SenderTask var1) throws SenderException, IOException;

    class SenderTask {
        private final Object event;
        private final BackOff backOff;
        private Map<String, String> properties = Maps.newHashMap();

        public SenderTask(Object event, BackOff backOff) {
            this.event = event;
            this.backOff = backOff;
        }

        public Object getEvent() {
            return this.event;
        }

        public BackOff getBackOff() {
            return this.backOff;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    class SenderException
    extends Exception {
        private final boolean retryable;

        public SenderException(boolean retryable) {
            this.retryable = retryable;
        }

        public SenderException(boolean retryable, Throwable cause) {
            super(cause);
            this.retryable = retryable;
        }

        public boolean isRetryable() {
            return this.retryable;
        }
    }
}

