/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import io.phasetwo.keycloak.events.AbstractEventListenerProvider;
import io.phasetwo.keycloak.events.AbstractEventListenerProviderFactory;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class UserEventListenerProviderFactory
extends AbstractEventListenerProviderFactory {
    private static final Logger log = Logger.getLogger(UserEventListenerProviderFactory.class);
    private KeycloakSessionFactory factory;

    public EventListenerProvider create(final KeycloakSession session) {
        return new AbstractEventListenerProvider(){

            @Override
            public void onEvent(Event event) {
                if (EventType.REGISTER.equals((Object)event.getType())) {
                    this.userAdded(event.getRealmId(), event.getUserId());
                }
            }

            @Override
            public void onEvent(AdminEvent adminEvent, boolean b) {
                if (ResourceType.USER.equals((Object)adminEvent.getResourceType()) && OperationType.CREATE.equals((Object)adminEvent.getOperationType())) {
                    String resourcePath = adminEvent.getResourcePath();
                    if (resourcePath.startsWith("users/")) {
                        this.userAdded(adminEvent.getRealmId(), resourcePath.substring("users/".length()));
                    } else {
                        log.warnf("AdminEvent was CREATE:USER without appropriate resourcePath=%s", (Object)resourcePath);
                    }
                }
            }

            void userAdded(final String realmId, final String userId) {
                session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

                    protected void commitImpl() {
                        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)UserEventListenerProviderFactory.this.factory, s -> {
                            RealmModel realm = s.realms().getRealm(realmId);
                            UserModel user = s.users().getUserById(realm, userId);
                            UserEventListenerProviderFactory.this.getUserChangedHandler().onUserAdded(s, realm, user);
                        });
                    }

                    protected void rollbackImpl() {
                    }
                });
            }
        };
    }

    abstract UserChangedHandler getUserChangedHandler();

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        this.factory = factory;
        factory.register(event -> {
            if (event instanceof UserModel.UserRemovedEvent) {
                UserModel.UserRemovedEvent removal = (UserModel.UserRemovedEvent)event;
                this.getUserChangedHandler().onUserRemoved(removal.getKeycloakSession(), removal.getRealm(), removal.getUser());
            }
        });
    }

    abstract class UserChangedHandler {
        UserChangedHandler() {
        }

        abstract void onUserAdded(KeycloakSession var1, RealmModel var2, UserModel var3);

        abstract void onUserRemoved(KeycloakSession var1, RealmModel var2, UserModel var3);
    }
}

