/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import com.google.common.base.Strings;
import io.phasetwo.keycloak.events.HttpSenderEventListenerProvider;
import io.phasetwo.keycloak.events.RunnableTransaction;
import io.phasetwo.keycloak.events.SenderEventListenerProvider;
import io.phasetwo.keycloak.model.WebhookModel;
import io.phasetwo.keycloak.model.WebhookProvider;
import io.phasetwo.keycloak.representation.ExtendedAdminEvent;
import io.phasetwo.keycloak.representation.ExtendedAuthDetails;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class WebhookSenderEventListenerProvider
extends HttpSenderEventListenerProvider {
    private static final Logger log = Logger.getLogger(WebhookSenderEventListenerProvider.class);
    private static final String WEBHOOK_URI_ENV = "WEBHOOK_URI";
    private static final String WEBHOOK_SECRET_ENV = "WEBHOOK_SECRET";
    private static final String WEBHOOK_ALGORITHM_ENV = "WEBHOOK_ALGORITHM";
    private final RunnableTransaction runnableTrx;
    private final KeycloakSessionFactory factory;
    private final String systemUri;
    private final String systemSecret;
    private final String systemAlgorithm;

    public WebhookSenderEventListenerProvider(KeycloakSession session, ScheduledExecutorService exec) {
        super(session, exec);
        this.factory = session.getKeycloakSessionFactory();
        this.runnableTrx = new RunnableTransaction();
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.runnableTrx);
        this.systemUri = System.getenv(WEBHOOK_URI_ENV);
        this.systemSecret = System.getenv(WEBHOOK_SECRET_ENV);
        this.systemAlgorithm = System.getenv(WEBHOOK_ALGORITHM_ENV);
    }

    @Override
    public void onEvent(Event event) {
        log.debugf("onEvent %s %s", (Object)event.getType(), (Object)event.getId());
        try {
            ExtendedAdminEvent customEvent = this.completeAdminEventAttributes("", event);
            this.runnableTrx.addRunnable(() -> this.processEvent(customEvent, event.getRealmId()));
        }
        catch (Exception e) {
            log.warn((Object)("Error converting and scheduling event: " + event), (Throwable)e);
        }
    }

    @Override
    public void onEvent(AdminEvent adminEvent, boolean b) {
        log.debugf("onEvent %s %s %s", (Object)adminEvent.getOperationType(), (Object)adminEvent.getResourceTypeAsString(), (Object)adminEvent.getResourcePath());
        try {
            ExtendedAdminEvent customEvent = this.completeAdminEventAttributes("", adminEvent);
            this.runnableTrx.addRunnable(() -> this.processEvent(customEvent, adminEvent.getRealmId()));
        }
        catch (Exception e) {
            log.warn((Object)("Error converting and scheduling event: " + adminEvent), (Throwable)e);
        }
    }

    public void processEvent(ExtendedAdminEvent customEvent, String realmId) {
        this.processEvent(() -> {
            customEvent.setUid(KeycloakModelUtils.generateId());
            return customEvent;
        }, realmId);
    }

    private void processEvent(Supplier<ExtendedAdminEvent> supplier, String realmId) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, session -> {
            RealmModel realm = session.realms().getRealm(realmId);
            WebhookProvider webhooks = (WebhookProvider)session.getProvider(WebhookProvider.class);
            webhooks.getWebhooksStream(realm).filter(w -> w.isEnabled()).filter(w -> !Strings.isNullOrEmpty((String)w.getUrl())).forEach(arg_0 -> this.lambda$processEvent$5((Supplier)supplier, arg_0));
            if (!Strings.isNullOrEmpty((String)this.systemUri)) {
                this.schedule((ExtendedAdminEvent)((Object)((Object)supplier.get())), this.systemUri, this.systemSecret, this.systemAlgorithm);
            }
        });
    }

    private void schedule(ExtendedAdminEvent customEvent, String url, String secret, String algorithm) {
        SenderEventListenerProvider.SenderTask task = new SenderEventListenerProvider.SenderTask(this, (Object)customEvent, this.getBackOff());
        task.getProperties().put("url", url);
        task.getProperties().put("secret", secret);
        task.getProperties().put("algorithm", algorithm);
        this.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    private boolean enabledFor(WebhookModel webhook, ExtendedAdminEvent customEvent) {
        String type = customEvent.getType();
        log.debugf("Checking webhook enabled for %s [%s]", (Object)type, webhook.getEventTypes());
        for (String t : webhook.getEventTypes()) {
            if ("*".equals(t)) {
                return true;
            }
            if ("access.*".equals(t) && type.startsWith("access.")) {
                return true;
            }
            if ("admin.*".equals(t) && type.startsWith("admin.")) {
                return true;
            }
            if ("system.*".equals(t) && type.startsWith("system.")) {
                return true;
            }
            try {
                if (Pattern.matches(t, type)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!t.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    void send(SenderEventListenerProvider.SenderTask task) throws SenderEventListenerProvider.SenderException, IOException {
        String targetUri = task.getProperties().get("url");
        Optional<String> sharedSecret = Optional.ofNullable(task.getProperties().get("secret"));
        Optional<String> hmacAlgorithm = Optional.ofNullable(task.getProperties().get("algorithm"));
        this.send(task, targetUri, sharedSecret, hmacAlgorithm);
    }

    private ExtendedAdminEvent completeAdminEventAttributes(String uid, Event event) {
        UserModel user;
        RealmModel realm = this.session.realms().getRealm(event.getRealmId());
        ExtendedAdminEvent extendedAdminEvent = new ExtendedAdminEvent(uid, event, realm);
        if (!Strings.isNullOrEmpty((String)event.getUserId()) && (user = this.session.users().getUserById(realm, event.getUserId())) != null) {
            extendedAdminEvent.getAuthDetails().setUsername(user.getUsername());
        }
        this.completeExtendedAuthDetails(extendedAdminEvent);
        return extendedAdminEvent;
    }

    private ExtendedAdminEvent completeAdminEventAttributes(String uid, AdminEvent adminEvent) {
        String pattern;
        Pattern r;
        Matcher m;
        String resourcePath;
        RealmModel realm = this.session.realms().getRealm(adminEvent.getRealmId());
        ExtendedAdminEvent extendedAdminEvent = new ExtendedAdminEvent(uid, adminEvent, realm);
        ExtendedAuthDetails extendedAuthDetails = extendedAdminEvent.getAuthDetails();
        if (!Strings.isNullOrEmpty((String)extendedAuthDetails.getUserId())) {
            UserModel user = this.session.users().getUserById(realm, extendedAuthDetails.getUserId());
            extendedAuthDetails.setUsername(user.getUsername());
        }
        if ((resourcePath = extendedAdminEvent.getResourcePath()) != null && resourcePath.startsWith("users") && (m = (r = Pattern.compile(pattern = "^users/([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$")).matcher(resourcePath)).matches()) {
            String userId = m.group(1);
            UserModel user = this.session.users().getUserById(this.session.realms().getRealm(adminEvent.getRealmId()), userId);
            extendedAdminEvent.getDetails().put("userId", userId);
            if (user != null) {
                extendedAdminEvent.getDetails().put("username", user.getUsername());
            }
        }
        this.completeExtendedAuthDetails(extendedAdminEvent);
        return extendedAdminEvent;
    }

    private ExtendedAdminEvent completeExtendedAuthDetails(ExtendedAdminEvent event) {
        ExtendedAuthDetails details = event.getAuthDetails();
        if (details == null) {
            return event;
        }
        try {
            details.setSessionId(this.session.getContext().getAuthenticationSession().getParentSession().getId());
        }
        catch (Exception e) {
            log.debug((Object)"couldn't get sessionId", (Throwable)e);
        }
        try {
            details.setRealmId(this.session.getContext().getAuthenticationSession().getParentSession().getRealm().getName());
        }
        catch (Exception e) {
            log.debug((Object)"couldn't get realmId", (Throwable)e);
        }
        return event;
    }

    private /* synthetic */ void lambda$processEvent$5(Supplier supplier, WebhookModel w) {
        ExtendedAdminEvent customEvent = (ExtendedAdminEvent)((Object)supplier.get());
        if (!this.enabledFor(w, customEvent)) {
            return;
        }
        this.schedule(customEvent, w.getUrl(), w.getSecret(), w.getAlgorithm());
    }
}

