/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.events;

import com.google.auto.service.AutoService;
import com.google.common.util.concurrent.MoreExecutors;
import io.phasetwo.keycloak.events.AbstractEventListenerProviderFactory;
import io.phasetwo.keycloak.events.WebhookSenderEventListenerProvider;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;

@AutoService(value={EventListenerProviderFactory.class})
public class WebhookSenderEventListenerProviderFactory
extends AbstractEventListenerProviderFactory {
    private static final Logger log = Logger.getLogger(WebhookSenderEventListenerProviderFactory.class);
    public static final String PROVIDER_ID = "ext-event-webhook";
    private ScheduledExecutorService exec;

    public String getId() {
        return PROVIDER_ID;
    }

    public WebhookSenderEventListenerProvider create(KeycloakSession session) {
        return new WebhookSenderEventListenerProvider(session, this.exec);
    }

    @Override
    public void init(Config.Scope scope) {
        this.exec = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors()));
    }

    @Override
    public void close() {
        try {
            log.info((Object)"Shutting down scheduler");
            this.exec.shutdown();
        }
        catch (Exception e) {
            log.warn((Object)"Error in shutdown of scheduler", (Throwable)e);
        }
    }
}

