/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.model.jpa;

import io.phasetwo.keycloak.model.WebhookModel;
import io.phasetwo.keycloak.model.WebhookProvider;
import io.phasetwo.keycloak.model.jpa.WebhookAdapter;
import io.phasetwo.keycloak.model.jpa.entity.WebhookEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaWebhookProvider
implements WebhookProvider {
    protected final KeycloakSession session;
    protected final EntityManager em;

    public JpaWebhookProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    @Override
    public WebhookModel createWebhook(RealmModel realm, String url, UserModel createdBy) {
        WebhookEntity e = new WebhookEntity();
        e.setId(KeycloakModelUtils.generateId());
        e.setRealmId(realm.getId());
        e.setUrl(url);
        e.setCreatedBy(createdBy.getId());
        this.em.persist((Object)e);
        this.em.flush();
        WebhookAdapter webhook = new WebhookAdapter(this.session, realm, this.em, e);
        return webhook;
    }

    @Override
    public WebhookModel getWebhookById(RealmModel realm, String id) {
        WebhookEntity webhook = (WebhookEntity)this.em.find(WebhookEntity.class, (Object)id);
        if (webhook != null && webhook.getRealmId().equals(realm.getId())) {
            return new WebhookAdapter(this.session, realm, this.em, webhook);
        }
        return null;
    }

    @Override
    public Stream<WebhookModel> getWebhooksStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("getWebhooksByRealmId", WebhookEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultStream().map(e -> new WebhookAdapter(this.session, realm, this.em, (WebhookEntity)e));
    }

    @Override
    public boolean removeWebhook(RealmModel realm, String id) {
        WebhookEntity e = (WebhookEntity)this.em.find(WebhookEntity.class, (Object)id);
        this.em.remove((Object)e);
        this.em.flush();
        return true;
    }

    @Override
    public void removeWebhooks(RealmModel realm) {
        Query query = this.em.createNamedQuery("removeAllWebhooks");
        query.setParameter("realmId", (Object)realm.getId());
        query.executeUpdate();
    }

    public void close() {
    }
}

